package cn.com.poc.agent_application.rest.impl;

import cn.com.poc.agent_application.convert.BizAgentApplicationPluginConvert;
import cn.com.poc.agent_application.dto.AgentApplicationPluginClassificationDto;
import cn.com.poc.agent_application.dto.AgentApplicationPluginDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationPluginEntity;
import cn.com.poc.agent_application.query.AgentPluginQueryCondition;
import cn.com.poc.agent_application.query.AgentPluginQueryItem;
import cn.com.poc.agent_application.rest.BizAgentApplicationPluginRest;
import cn.com.poc.agent_application.service.BizAgentApplicationPluginService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.BlContext;
import cn.com.yict.framemax.core.context.Context;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

@Component
public class BizAgentApplicationPluginRestImpl implements BizAgentApplicationPluginRest {

    @Resource
    private BizAgentApplicationPluginService bizAgentApplicationPluginService;

    @Override
    public AgentApplicationPluginDto getByPluginId(String pluginId) {
        BizAgentApplicationPluginEntity bizAgentApplicationPluginEntity = new BizAgentApplicationPluginEntity();
        bizAgentApplicationPluginEntity.setPluginId(pluginId);
        BizAgentApplicationPluginEntity entity = bizAgentApplicationPluginService.getInfoById(pluginId);
        return BizAgentApplicationPluginConvert.entityToDto(entity, BlContext.getCurrentLocaleLanguageToLowerCase());
    }

    @Override
    public List<AgentApplicationPluginDto> getList(String classification, List<String> pluginIds, PagingInfo pagingInfo) throws Exception {
        AgentPluginQueryCondition condition = new AgentPluginQueryCondition();
        condition.setPluginIds(pluginIds);
        condition.setClassification(classification);
        List<AgentPluginQueryItem> agentPluginQueryItems = bizAgentApplicationPluginService.agentPluginQuery(condition, pagingInfo);
        return BizAgentApplicationPluginConvert.itemsToPluginDtos(agentPluginQueryItems, BlContext.getCurrentLocaleLanguageToLowerCase());
    }

    @Override
    public List<AgentApplicationPluginClassificationDto> classificationList() {
        BizAgentApplicationPluginEntity bizAgentApplicationPluginEntity = new BizAgentApplicationPluginEntity();
        bizAgentApplicationPluginEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationPluginEntity> entities = bizAgentApplicationPluginService.findByExample(bizAgentApplicationPluginEntity, null);
        return BizAgentApplicationPluginConvert.entitiesToClassificationDtos(entities.stream().filter(entity -> !"system".equals(entity.getClassification())).collect(Collectors.toList()), BlContext.getCurrentLocaleLanguageToLowerCase());
    }
}