package cn.com.poc.equity.service.impl;

import cn.com.poc.equity.convert.BizMemberEquityTransactionHistoryConvert;
import cn.com.poc.equity.entity.BizMemberEquityTransactionHistoryEntity;
import cn.com.poc.equity.model.BizMemberEquityTransactionHistoryModel;
import cn.com.poc.equity.query.QueryEquityTransactionHistoryQueryCondition;
import cn.com.poc.equity.query.QueryEquityTransactionHistoryQueryItem;
import cn.com.poc.equity.repository.BizMemberEquityTransactionHistoryRepository;
import cn.com.poc.equity.service.BizMemberEquityTransactionHistoryService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizMemberEquityTransactionHistoryServiceImpl extends BaseServiceImpl
        implements BizMemberEquityTransactionHistoryService {

    @Resource
    private BizMemberEquityTransactionHistoryRepository repository;

    public BizMemberEquityTransactionHistoryEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberEquityTransactionHistoryModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMemberEquityTransactionHistoryConvert.modelToEntity(model);
    }


    public List<BizMemberEquityTransactionHistoryEntity> findByExample(BizMemberEquityTransactionHistoryEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizMemberEquityTransactionHistoryEntity> result = new ArrayList<BizMemberEquityTransactionHistoryEntity>();
        BizMemberEquityTransactionHistoryModel model = new BizMemberEquityTransactionHistoryModel();
        if (example != null) {
            model = BizMemberEquityTransactionHistoryConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberEquityTransactionHistoryModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberEquityTransactionHistoryConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberEquityTransactionHistoryEntity save(BizMemberEquityTransactionHistoryEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberEquityTransactionHistoryModel model = BizMemberEquityTransactionHistoryConvert.entityToModel(entity);
        BizMemberEquityTransactionHistoryModel saveModel = this.repository.save(model);
        return BizMemberEquityTransactionHistoryConvert.modelToEntity(saveModel);
    }

    public BizMemberEquityTransactionHistoryEntity update(BizMemberEquityTransactionHistoryEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMemberEquityTransactionHistoryModel model = this.repository.get(entity.getId());

        if (entity.getTransactionSn() != null) {
            model.setTransactionSn(entity.getTransactionSn());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getOriginalEquityLevel() != null) {
            model.setOriginalEquityLevel(entity.getOriginalEquityLevel());
        }
        if (entity.getModifyEquityLevel() != null) {
            model.setModifyEquityLevel(entity.getModifyEquityLevel());
        }
        if (entity.getModifyEvent() != null) {
            model.setModifyEvent(entity.getModifyEvent());
        }
        if (entity.getModifyEventInfo() != null) {
            model.setModifyEventInfo(entity.getModifyEventInfo());
        }
        if (entity.getTargetEquityId() != null) {
            model.setTargetEquityId(entity.getTargetEquityId());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizMemberEquityTransactionHistoryModel saveModel = this.repository.save(model);
        return BizMemberEquityTransactionHistoryConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberEquityTransactionHistoryModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<QueryEquityTransactionHistoryQueryItem> queryEquityTransactionHistory(QueryEquityTransactionHistoryQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, QueryEquityTransactionHistoryQueryItem.class, pagingInfo);
    }
}