package cn.com.poc.equity.service.impl;

import cn.com.poc.equity.convert.BizMemberPointsConvert;
import cn.com.poc.equity.entity.BizMemberPointsEntity;
import cn.com.poc.equity.model.BizMemberPointsModel;
import cn.com.poc.equity.query.MemberPointsQueryCondition;
import cn.com.poc.equity.query.MemberPointsQueryItem;
import cn.com.poc.equity.repository.BizMemberPointsRepository;
import cn.com.poc.equity.service.BizMemberPointsService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizMemberPointsServiceImpl extends BaseServiceImpl
        implements BizMemberPointsService {

    @Resource
    private BizMemberPointsRepository repository;

    public BizMemberPointsEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberPointsModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMemberPointsConvert.modelToEntity(model);
    }


    public List<BizMemberPointsEntity> findByExample(BizMemberPointsEntity example, PagingInfo pagingInfo) {
        List<BizMemberPointsEntity> result = new ArrayList<BizMemberPointsEntity>();
        BizMemberPointsModel model = new BizMemberPointsModel();
        if (example != null) {
            model = BizMemberPointsConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberPointsModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberPointsConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberPointsEntity save(BizMemberPointsEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberPointsModel model = BizMemberPointsConvert.entityToModel(entity);
        BizMemberPointsModel saveModel = this.repository.save(model);
        return BizMemberPointsConvert.modelToEntity(saveModel);
    }

    public BizMemberPointsEntity update(BizMemberPointsEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMemberPointsModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getTotalPoints() != null) {
            model.setTotalPoints(entity.getTotalPoints());
        }
        if (entity.getUsagePoints() != null) {
            model.setUsagePoints(entity.getUsagePoints());
        }
        if (entity.getExpiredTime() != null) {
            model.setExpiredTime(entity.getExpiredTime());
        }
        BizMemberPointsModel saveModel = this.repository.save(model);
        return BizMemberPointsConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberPointsModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }


    @Override
    public Long getMemberPoints(Long memberId) {
        Long result = 0L;
        MemberPointsQueryCondition condition = new MemberPointsQueryCondition();
        condition.setMemberId(memberId);
        List<MemberPointsQueryItem> items = this.sqlDao.query(condition, MemberPointsQueryItem.class);
        if (CollectionUtils.isNotEmpty(items)) {
            result = items.get(0).getUsagePoints();
        }
        return result;
    }
}