package cn.com.poc.support.sms.constant;

/**
 * 短信常量
 *
 * @author Focan.Zhong
 */
public interface SmsConstant {

    /**
     * 第三方短信渠道
     */
    enum Channel {
        /**
         * 百度
         */
        baidu,

        ;
    }

    /**
     * 短信发送状态
     */
    interface Status {
        /**
         * 百联状态
         * <p>
         * FAIL("0","滑块校验失败")
         * INVALID("2","无效已过期的滑块验证码"),
         * SEND_CODE_SUCCESS("3","发送短信验证码成功"),
         * SEND_CODE_FAIL("4","发送短信验证码失败"),
         * OPERATING_FREQUENCY("5","操作过于频繁，请稍后再试！"),
         * VERIFY_CODE_FAIL("6","验证码错误")
         */
        enum BL {

            FAIL("FAIL", "0", ""),
            INVALID("INVALID", "2", ""),
            SEND_CODE_SUCCESS("SEND_CODE_SUCCESS", "3", ""),
            SEND_CODE_FAIL("SEND_CODE_FAIL", "4", ""),
            OPERATING_FREQUENCY("OPERATING_FREQUENCY", "5", ""),
            VERIFY_CODE_FAIL("VERIFY_CODE_FAIL", "6", ""),

            ;

            private String code;
            private String status;
            private String msg;

            BL(String code, String status, String msg) {
                this.code = code;
                this.status = status;
                this.msg = msg;
            }

            public String getCode() {
                return code;
            }

            public String getStatus() {
                return status;
            }

            public String getMsg() {
                return msg;
            }

            public static BL getByStatus(String status) {
                if (FAIL.getStatus().equals(status)) {
                    return FAIL;
                }
                if (INVALID.getStatus().equals(status)) {
                    return INVALID;
                }
                if (SEND_CODE_SUCCESS.getStatus().equals(status)) {
                    return SEND_CODE_SUCCESS;
                }
                if (SEND_CODE_FAIL.getStatus().equals(status)) {
                    return SEND_CODE_FAIL;
                }
                if (OPERATING_FREQUENCY.getStatus().equals(status)) {
                    return OPERATING_FREQUENCY;
                }
                if (VERIFY_CODE_FAIL.getStatus().equals(status)) {
                    return VERIFY_CODE_FAIL;
                }
                return null;
            }
        }

    }

}
