package cn.com.poc.thirdparty.resource.demand.ai.function.image_ocr;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.hutool.core.collection.ListUtil;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/14
 */
@Component
public class ImageOCRFunction extends AbstractLargeModelFunction {

    private final String DESC = "该方法是通过OCR获取图片内容，并且根据用户提问对图片内容进行提取总结与分析。";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("image_ocr")
            .description(DESC)
            .parameters(new Parameters("object")
                    .addProperties("query", new Properties("string", "用户提问问题"))
                    .addProperties("image_url", new Properties("string", "图片地址")))
            .build();

    @Override
    public String doFunction(String content, String identifier) {

        //todo 对接豆包多模态大模型
        return null;
    }

    @Override
    public String getDesc() {
        return getDesc();
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return this.getLLMConfig();
    }
}
