package cn.com.poc.thirdparty.resource.demand.pay.rest.impl;


import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.equity.aggregate.EquityService;
import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.demand.dgTools.result.PayResult;
import cn.com.poc.thirdparty.resource.demand.pay.constants.PayChannel;
import cn.com.poc.thirdparty.resource.demand.pay.dto.PayOrderStatusDto;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.poc.thirdparty.resource.demand.pay.service.DgtoolsPayOrderService;
import cn.com.poc.thirdparty.resource.demand.pay.service.PayService;
import cn.com.poc.thirdparty.resource.demand.pay.dto.WxNativePayDto;
import cn.com.poc.thirdparty.resource.demand.pay.rest.PayRest;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.hutool.core.util.ObjectUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author Roger Wu
 */
@Component
public class PayRestImpl implements PayRest {

    @Resource
    private PayService payService;
    @Resource
    private DgtoolsPayOrderService dgtoolsPayOrderService;


    @Override
    public Object pay(String payChannel, String payOrderSn) throws Exception {
        Assert.notNull(payChannel);
        Assert.notNull(payOrderSn);
        // 获取当前登录用户
        UserBaseEntity currentUser = BlContext.getCurrentUserNotException();
        if (ObjectUtil.isEmpty(currentUser)) {
            throw new I18nMessageException("exception/user.not.login");
        }

        PayResult payResult = new PayResult();
        if (PayChannel.WX_NATIVE.name().equals(payChannel)) {
            WxNativePayDto wxNativePayDto = new WxNativePayDto();
            wxNativePayDto.setPayOrderSn(payOrderSn);
            payResult = payService.wxNativePay(wxNativePayDto);
        } else if (PayChannel.ALI_NATIVE.name().equals(payChannel)) {
            payResult = payService.aliPayNative(payOrderSn);
        } else {
            throw new I18nMessageException("pay/payment.channel.not.currently.supported");
        }
        payResult.setPayOrderSn(payOrderSn);
        return payResult;
    }

    @Override
    public PayOrderStatusDto orderStatus(String payOrderSn) throws Exception {
        Assert.notNull(payOrderSn);
        DgtoolsPayOrderEntity payOrderEntity = dgtoolsPayOrderService.findPayOrderByPaySn(payOrderSn);
        if (payOrderEntity == null) {
            throw new I18nMessageException("pay/payment.order.not.exist");
        }
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity != null && userBaseEntity.getUserId().intValue() != payOrderEntity.getMemberId()) {
            throw new I18nMessageException("pay/no.right.view.this.order");
        }
        PayOrderStatusDto payOrderStatusDto = new PayOrderStatusDto();
        payOrderStatusDto.setPayOrderSn(payOrderSn);
        payOrderStatusDto.setPayStatus(payOrderEntity.getPayStatus());
        return payOrderStatusDto;
    }
}
