package cn.com.poc.user.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_member_3rd_party_relation
 * 用户信息关联表
 */
@Entity
@Table(name = "biz_member_3rd_party_relation")
@DynamicInsert
@DynamicUpdate
public class BizMember3rdPartyRelationModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *
    */ 
    private Integer id;
    @Column(name = "id",length = 10)
    @Id @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }


  
    /** memberId
    *会员id
    */ 
    private Integer memberId;
    
    @Column(name = "member_id",length = 50)
    public Integer getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(Integer memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** relation_key
    *
    */ 
    private String relationKey;
    
    @Column(name = "relation_key",length = 255)
    public String getRelationKey(){
        return this.relationKey;
    }
    
    public void setRelationKey(String relationKey){
        this.relationKey = relationKey;
        super.addValidField("relationKey");
    }
    
  
    /** relation_platform
    *
    */ 
    private String relationPlatform;
    
    @Column(name = "relation_platform",length = 50)
    public String getRelationPlatform(){
        return this.relationPlatform;
    }
    
    public void setRelationPlatform(String relationPlatform){
        this.relationPlatform = relationPlatform;
        super.addValidField("relationPlatform");
    }
    
  
    /** is_deleted
    *是否删除 Y-是 N-否
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 50)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    

    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 50)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}