package cn.com.poc.agent_application.convert;

import cn.com.poc.agent_application.domain.*;
import cn.com.poc.agent_application.dto.AgentApplicationInfoDto;
import cn.com.poc.agent_application.entity.BizAgentApplicationInfoEntity;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.agent_application.entity.VoiceConfig;
import cn.com.poc.agent_application.model.BizAgentApplicationInfoModel;
import cn.com.poc.agent_application.query.AgentApplicationInfoQueryItem;
import cn.com.poc.agent_application.query.PublishAgentApplicationQueryItem;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.expose.dto.SearchAgentApplicationDto;
import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.core.utils.JsonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class AgentApplicationInfoConvert {

    public static SearchAgentApplicationDto itemToSearchDto(PublishAgentApplicationQueryItem item) {
        SearchAgentApplicationDto dto = new SearchAgentApplicationDto();
        dto.setAgentId(item.getAgentId());
        dto.setAgentTitle(item.getAgentTitle());
        dto.setAgentDesc(item.getAgentDesc());
        dto.setAgentAvatar(item.getAgentAvatar());
        dto.setPublishedTime(item.getModifiedTime());
        dto.setCreator(item.getNickName());
        return dto;
    }

    public static BizAgentApplicationInfoEntity modelToEntity(BizAgentApplicationInfoModel model) {
        BizAgentApplicationInfoEntity entity = new BizAgentApplicationInfoEntity();
        entity.setId(model.getId());
        entity.setMemberId(model.getMemberId());
        entity.setAgentId(model.getAgentId());
        entity.setAgentTitle(model.getAgentTitle());
        entity.setAgentDesc(model.getAgentDesc());
        entity.setAgentAvatar(model.getAgentAvatar());
        entity.setAgentSystem(model.getAgentSystem());
        entity.setAgentPublishStatus(model.getAgentPublishStatus());
        entity.setPreamble(model.getPreamble());
        entity.setPublishTime(model.getPublishTime());
        entity.setIsLongMemory(model.getIsLongMemory());
        if (StringUtils.isNotBlank(model.getVariableStructure())) {
            entity.setVariableStructure(JsonUtils.deSerialize(model.getVariableStructure(), new TypeReference<List<Variable>>() {
            }.getType()));
        }
        if (StringUtils.isNotBlank(model.getFeaturedQuestions())) {
            entity.setFeaturedQuestions(JsonUtils.deSerialize(model.getFeaturedQuestions(), String[].class));
        }
        entity.setCommunicationTurn(model.getCommunicationTurn());
        entity.setContinuousQuestionStatus(model.getContinuousQuestionStatus());
        entity.setContinuousQuestionSystem(model.getContinuousQuestionSystem());
        entity.setContinuousQuestionTurn(model.getContinuousQuestionTurn());
        if (StringUtils.isNotBlank(model.getKnowledgeIds())) {
            entity.setKnowledgeIds(JsonUtils.deSerialize(model.getKnowledgeIds(), Integer[].class));
        }
        entity.setIsDocumentParsing(model.getIsDocumentParsing());
        entity.setLargeModel(model.getLargeModel());
        entity.setTopP(model.getTopP());
        entity.setTemperature(model.getTemperature());
        if (StringUtils.isNotBlank(model.getUnitIds())) {
            entity.setUnitIds(JsonUtils.deSerialize(model.getUnitIds(), String[].class));
        }
        if (StringUtils.isNotBlank(model.getVoiceConfig())) {
            VoiceConfig voiceConfig = JsonUtils.deSerialize(model.getVoiceConfig(), VoiceConfig.class);
            entity.setVoiceConfig(voiceConfig);
        }
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizAgentApplicationInfoModel entityToModel(BizAgentApplicationInfoEntity entity) {
        BizAgentApplicationInfoModel model = new BizAgentApplicationInfoModel();
        model.setId(entity.getId());
        model.setMemberId(entity.getMemberId());
        model.setAgentId(entity.getAgentId());
        model.setAgentTitle(entity.getAgentTitle());
        model.setAgentAvatar(entity.getAgentAvatar());
        model.setAgentDesc(entity.getAgentDesc());
        model.setAgentSystem(entity.getAgentSystem());
        model.setAgentPublishStatus(entity.getAgentPublishStatus());
        model.setPreamble(entity.getPreamble());
        model.setPublishTime(entity.getPublishTime());
        model.setIsLongMemory(entity.getIsLongMemory());
        model.setIsDocumentParsing(entity.getIsDocumentParsing());
        if (CollectionUtils.isNotEmpty(entity.getVariableStructure())) {
            model.setVariableStructure(JsonUtils.serialize(entity.getVariableStructure()));
        }
        if (ArrayUtils.isNotEmpty(entity.getFeaturedQuestions())) {
            model.setFeaturedQuestions(JsonUtils.serialize(entity.getFeaturedQuestions()));
        }
        model.setCommunicationTurn(entity.getCommunicationTurn());
        model.setContinuousQuestionStatus(entity.getContinuousQuestionStatus());
        model.setContinuousQuestionSystem(entity.getContinuousQuestionSystem());
        model.setContinuousQuestionTurn(entity.getContinuousQuestionTurn());
        if (ArrayUtils.isNotEmpty(entity.getKnowledgeIds())) {
            model.setKnowledgeIds(JsonUtils.serialize(entity.getKnowledgeIds()));
        }
        model.setLargeModel(entity.getLargeModel());
        model.setTopP(entity.getTopP());
        model.setTemperature(entity.getTemperature());
        if (ArrayUtils.isNotEmpty(entity.getUnitIds())) {
            model.setUnitIds(JsonUtil.toJson(entity.getUnitIds()));
        }
        if (ObjectUtil.isNotEmpty(entity.getVoiceConfig())) {
            model.setVoiceConfig(JsonUtils.serialize(entity.getVoiceConfig()));
        }
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static AgentApplicationInfoDto entityToDto(BizAgentApplicationInfoEntity entity) {
        AgentApplicationBaseInfo baseInfo = new AgentApplicationBaseInfo();
        baseInfo.setMemberId(entity.getMemberId());
        baseInfo.setAgentId(entity.getAgentId());
        baseInfo.setAgentTitle(entity.getAgentTitle());
        baseInfo.setAgentAvatar(entity.getAgentAvatar());
        baseInfo.setAgentDesc(entity.getAgentDesc());
        baseInfo.setAgentSystem(entity.getAgentSystem());
        baseInfo.setAgentPublishStatus(entity.getAgentPublishStatus());
        baseInfo.setPublishTime(entity.getPublishTime());

        AgentApplicationCommConfig commConfig = new AgentApplicationCommConfig();
        commConfig.setPreamble(entity.getPreamble());
        commConfig.setFeaturedQuestions(entity.getFeaturedQuestions());
        commConfig.setContinuousQuestionStatus(entity.getContinuousQuestionStatus());
        commConfig.setContinuousQuestionSystem(entity.getContinuousQuestionSystem());
        commConfig.setContinuousQuestionTurn(entity.getContinuousQuestionTurn());
        commConfig.setVariableStructure(entity.getVariableStructure());
        commConfig.setIsLongMemory(entity.getIsLongMemory());


        AgentApplicationKnowledgeConfig knowledgeConfig = new AgentApplicationKnowledgeConfig();
        knowledgeConfig.setKnowledgeIds(entity.getKnowledgeIds());
        knowledgeConfig.setIsDocumentParsing(entity.getIsDocumentParsing());

        AgentApplicationCommModelConfig commModelConfig = new AgentApplicationCommModelConfig();
        commModelConfig.setLargeModel(entity.getLargeModel());
        commModelConfig.setTopP(entity.getTopP());
        commModelConfig.setTemperature(entity.getTemperature());
        commModelConfig.setCommunicationTurn(entity.getCommunicationTurn());

        AgentApplicationVoiceConfig voiceConfig = new AgentApplicationVoiceConfig();
        if (ObjectUtil.isNotEmpty(entity.getVoiceConfig())) {
            voiceConfig.setDefaultOpen(entity.getVoiceConfig().getDefaultOpen());
            voiceConfig.setTimbreId(entity.getVoiceConfig().getTimbreId());
        } else {
            voiceConfig.setDefaultOpen(CommonConstant.YOrN.N);
            voiceConfig.setTimbreId(StringUtils.EMPTY);
        }

        AgentApplicationInfoDto dto = new AgentApplicationInfoDto();
        dto.setBaseInfo(baseInfo);
        dto.setCommConfig(commConfig);
        dto.setKnowledgeConfig(knowledgeConfig);
        dto.setCommModelConfig(commModelConfig);
        dto.setVoiceConfig(voiceConfig);
        dto.setUnitIds(entity.getUnitIds());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifiedTime(entity.getModifiedTime());
        return dto;
    }

    public static BizAgentApplicationInfoEntity dtoToEntity(AgentApplicationInfoDto dto) {
        BizAgentApplicationInfoEntity entity = new BizAgentApplicationInfoEntity();
        if (ObjectUtil.isNotEmpty(dto.getBaseInfo())) {
            entity.setAgentId(dto.getBaseInfo().getAgentId());
            entity.setMemberId(dto.getBaseInfo().getMemberId());
            entity.setAgentAvatar(dto.getBaseInfo().getAgentAvatar());
            entity.setMemberId(dto.getBaseInfo().getMemberId());
            entity.setAgentTitle(dto.getBaseInfo().getAgentTitle());
            entity.setAgentDesc(dto.getBaseInfo().getAgentDesc());
            entity.setAgentSystem(dto.getBaseInfo().getAgentSystem());
            entity.setAgentPublishStatus(dto.getBaseInfo().getAgentPublishStatus());
            entity.setPublishTime(dto.getBaseInfo().getPublishTime());
        }

        if (ObjectUtil.isNotEmpty(dto.getCommConfig())) {
            entity.setPreamble(dto.getCommConfig().getPreamble());
            entity.setFeaturedQuestions(dto.getCommConfig().getFeaturedQuestions());
            entity.setContinuousQuestionStatus(dto.getCommConfig().getContinuousQuestionStatus());
            entity.setContinuousQuestionSystem(dto.getCommConfig().getContinuousQuestionSystem());
            entity.setContinuousQuestionTurn(dto.getCommConfig().getContinuousQuestionTurn());
            if (CollectionUtils.isNotEmpty(dto.getCommConfig().getVariableStructure())) {
                entity.setVariableStructure(dto.getCommConfig().getVariableStructure());
            }
            entity.setIsLongMemory(dto.getCommConfig().getIsLongMemory());
        }

        if (ObjectUtil.isNotEmpty(dto.getKnowledgeConfig())) {
            entity.setKnowledgeIds(dto.getKnowledgeConfig().getKnowledgeIds());
            entity.setIsDocumentParsing(dto.getKnowledgeConfig().getIsDocumentParsing());
        }

        if (ObjectUtil.isNotEmpty(dto.getCommModelConfig())) {
            entity.setLargeModel(dto.getCommModelConfig().getLargeModel());
            entity.setTopP(dto.getCommModelConfig().getTopP());
            entity.setTemperature(dto.getCommModelConfig().getTemperature());
            entity.setCommunicationTurn(dto.getCommModelConfig().getCommunicationTurn());
        }

        VoiceConfig voiceConfig = new VoiceConfig();
        if (ObjectUtil.isNotEmpty(dto.getVoiceConfig())) {
            voiceConfig.setDefaultOpen(dto.getVoiceConfig().getDefaultOpen());
            voiceConfig.setTimbreId(dto.getVoiceConfig().getTimbreId());
        } else {
            voiceConfig.setDefaultOpen(CommonConstant.YOrN.N);
            voiceConfig.setTimbreId(StringUtils.EMPTY);
        }
        entity.setVoiceConfig(voiceConfig);

        entity.setUnitIds(dto.getUnitIds());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifiedTime(dto.getModifiedTime());
        return entity;
    }


    public static BizAgentApplicationInfoEntity queryItemToEntity(AgentApplicationInfoQueryItem infoQueryItem) {
        BizAgentApplicationInfoEntity entity = new BizAgentApplicationInfoEntity();
        entity.setId(infoQueryItem.getId());
        entity.setMemberId(infoQueryItem.getMemberId());
        entity.setAgentId(infoQueryItem.getAgentId());
        entity.setAgentTitle(infoQueryItem.getAgentTitle());
        entity.setAgentDesc(infoQueryItem.getAgentDesc());
        entity.setAgentAvatar(infoQueryItem.getAgentAvatar());
        entity.setAgentSystem(infoQueryItem.getAgentSystem());
        entity.setAgentPublishStatus(infoQueryItem.getAgentPublishStatus());
        entity.setPreamble(infoQueryItem.getPreamble());
        entity.setPublishTime(infoQueryItem.getPublishTime());
        entity.setIsLongMemory(infoQueryItem.getIsLongMemory());
        entity.setIsDocumentParsing(infoQueryItem.getIsDocumentParsing());

        if (StringUtils.isNotBlank(infoQueryItem.getVariableStructure())) {
            entity.setVariableStructure(JsonUtils.deSerialize(infoQueryItem.getVariableStructure(), new TypeReference<List<Variable>>() {
            }.getType()));
        }

        if (StringUtils.isNotBlank(infoQueryItem.getFeaturedQuestions())) {
            entity.setFeaturedQuestions(JsonUtils.deSerialize(infoQueryItem.getFeaturedQuestions(), String[].class));
        }
        entity.setCommunicationTurn(infoQueryItem.getCommunicationTurn());
        entity.setContinuousQuestionStatus(infoQueryItem.getContinuousQuestionStatus());
        entity.setContinuousQuestionSystem(infoQueryItem.getContinuousQuestionSystem());
        entity.setContinuousQuestionTurn(infoQueryItem.getContinuousQuestionTurn());
        if (StringUtils.isNotBlank(infoQueryItem.getKnowledgeIds())) {
            entity.setKnowledgeIds(JsonUtils.deSerialize(infoQueryItem.getKnowledgeIds(), Integer[].class));
        }
        entity.setLargeModel(infoQueryItem.getLargeModel());
        entity.setTopP(infoQueryItem.getTopP());
        entity.setTemperature(infoQueryItem.getTemperature());
        if (StringUtils.isNotBlank(infoQueryItem.getUnitIds())) {
            entity.setUnitIds(JsonUtils.deSerialize(infoQueryItem.getUnitIds(), String[].class));
        }
        if (StringUtils.isNotBlank(infoQueryItem.getVoiceConfig())) {
            entity.setVoiceConfig(JsonUtils.deSerialize(infoQueryItem.getVoiceConfig(), VoiceConfig.class));
        }
        entity.setIsDeleted(infoQueryItem.getIsDeleted());
        entity.setCreator(infoQueryItem.getCreator());
        entity.setCreatedTime(infoQueryItem.getCreatedTime());
        entity.setModifier(infoQueryItem.getModifier());
        entity.setModifiedTime(infoQueryItem.getModifiedTime());
        entity.setSysVersion(infoQueryItem.getSysVersion());
        return entity;

    }
}