package cn.com.poc.agent_application.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationApiConversationService;
import cn.com.poc.agent_application.model.BizAgentApplicationApiConversationModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationApiConversationEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationApiConversationConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationApiConversationRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationApiConversationServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationApiConversationService {

    @Resource
    private BizAgentApplicationApiConversationRepository repository;

    public BizAgentApplicationApiConversationEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationApiConversationModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizAgentApplicationApiConversationConvert.modelToEntity(model);
    }

    @Override
    public BizAgentApplicationApiConversationEntity getByConversationId(String conversationId) {
        BizAgentApplicationApiConversationModel model = new BizAgentApplicationApiConversationModel();
        model.setConversationId(conversationId);
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationApiConversationModel> models = this.repository.findByExample(model, null);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationApiConversationConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public List<BizAgentApplicationApiConversationEntity> findByExample(BizAgentApplicationApiConversationEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationApiConversationEntity> result = new ArrayList<BizAgentApplicationApiConversationEntity>();
        BizAgentApplicationApiConversationModel model = new BizAgentApplicationApiConversationModel();
        if (example != null) {
            model = BizAgentApplicationApiConversationConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizAgentApplicationApiConversationModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationApiConversationConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationApiConversationEntity save(BizAgentApplicationApiConversationEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizAgentApplicationApiConversationModel model = BizAgentApplicationApiConversationConvert.entityToModel(entity);
        BizAgentApplicationApiConversationModel saveModel = this.repository.save(model);
        return BizAgentApplicationApiConversationConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationApiConversationEntity update(BizAgentApplicationApiConversationEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationApiConversationModel model = this.repository.get(entity.getId());

        if (entity.getAgentId() != null) {
            model.setAgentId(entity.getAgentId());
        }
        if (entity.getConversationId() != null) {
            model.setConversationId(entity.getConversationId());
        }
        if (entity.getExpiredTime() != null) {
            model.setExpiredTime(entity.getExpiredTime());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAgentApplicationApiConversationModel saveModel = this.repository.save(model);
        return BizAgentApplicationApiConversationConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationApiConversationModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}