package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.convert.BizAgentApplicationApiProfileConvert;
import cn.com.poc.agent_application.entity.BizAgentApplicationApiProfileEntity;
import cn.com.poc.agent_application.model.BizAgentApplicationApiProfileModel;
import cn.com.poc.agent_application.repository.BizAgentApplicationApiProfileRepository;
import cn.com.poc.agent_application.service.BizAgentApplicationApiProfileService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.UUIDTool;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.core.lang.generator.SnowflakeGenerator;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

@Service
public class BizAgentApplicationApiProfileServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationApiProfileService {
    private SnowflakeGenerator snowflakeGenerator = new SnowflakeGenerator();

    @Resource
    private BizAgentApplicationApiProfileRepository repository;

    @Override
    public BizAgentApplicationApiProfileEntity getByMemberId(Long memberId) {
        BizAgentApplicationApiProfileModel model = new BizAgentApplicationApiProfileModel();
        model.setMemberId(memberId);
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationApiProfileModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationApiProfileConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    @Override
    public BizAgentApplicationApiProfileEntity initProfile(Long memberId) {
        BizAgentApplicationApiProfileEntity entity = this.getByMemberId(memberId);
        if (entity == null) {
            BizAgentApplicationApiProfileModel model = new BizAgentApplicationApiProfileModel();
            model.setMemberId(memberId);
            model.setApiKey(snowflakeGenerator.next().toString());
            model.setApiSecret(UUIDTool.getUUID());
            model.setIsDeleted(CommonConstant.IsDeleted.N);
            BizAgentApplicationApiProfileModel saveModel = this.repository.save(model);
            entity = BizAgentApplicationApiProfileConvert.modelToEntity(saveModel);
        }
        return entity;
    }

    @Override
    public BizAgentApplicationApiProfileEntity getByKeyAndSecret(String key, String secret) {
        BizAgentApplicationApiProfileModel model = new BizAgentApplicationApiProfileModel();
        model.setApiKey(key);
        model.setApiSecret(secret);
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationApiProfileModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationApiProfileConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public List<BizAgentApplicationApiProfileEntity> findByExample(BizAgentApplicationApiProfileEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationApiProfileEntity> result = new ArrayList<BizAgentApplicationApiProfileEntity>();
        BizAgentApplicationApiProfileModel model = new BizAgentApplicationApiProfileModel();
        if (example != null) {
            model = BizAgentApplicationApiProfileConvert.entityToModel(example);
        }
        model.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationApiProfileModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationApiProfileConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationApiProfileEntity save(BizAgentApplicationApiProfileEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setIsDeleted(CommonConstant.IsDeleted.N);
        BizAgentApplicationApiProfileModel model = BizAgentApplicationApiProfileConvert.entityToModel(entity);
        BizAgentApplicationApiProfileModel saveModel = this.repository.save(model);
        return BizAgentApplicationApiProfileConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationApiProfileEntity update(BizAgentApplicationApiProfileEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationApiProfileModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getApiKey() != null) {
            model.setApiKey(entity.getApiKey());
        }
        if (entity.getApiSecret() != null) {
            model.setApiSecret(entity.getApiSecret());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizAgentApplicationApiProfileModel saveModel = this.repository.save(model);
        return BizAgentApplicationApiProfileConvert.modelToEntity(saveModel);
    }


}