package cn.com.poc.agent_application.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationCategoryService;
import cn.com.poc.agent_application.model.BizAgentApplicationCategoryModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationCategoryEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationCategoryConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationCategoryRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizAgentApplicationCategoryServiceImpl extends BaseServiceImpl
 			 implements BizAgentApplicationCategoryService {
   
   @Resource
   private BizAgentApplicationCategoryRepository repository;
    			 
   public BizAgentApplicationCategoryEntity get(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAgentApplicationCategoryModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        return BizAgentApplicationCategoryConvert.modelToEntity(model);
   }

       
   public List<BizAgentApplicationCategoryEntity> findByExample(BizAgentApplicationCategoryEntity example,PagingInfo pagingInfo) throws Exception{
        List<BizAgentApplicationCategoryEntity> result = new  ArrayList<BizAgentApplicationCategoryEntity>();
        BizAgentApplicationCategoryModel model = new BizAgentApplicationCategoryModel();
        if (example != null){
            model = BizAgentApplicationCategoryConvert.entityToModel(example);
        }
        List<BizAgentApplicationCategoryModel> models = this.repository.findByExample(model,pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationCategoryConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationCategoryEntity save(BizAgentApplicationCategoryEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        BizAgentApplicationCategoryModel model = BizAgentApplicationCategoryConvert.entityToModel(entity);
        BizAgentApplicationCategoryModel saveModel =  this.repository.save(model);
        return BizAgentApplicationCategoryConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationCategoryEntity update(BizAgentApplicationCategoryEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizAgentApplicationCategoryModel model = this.repository.get(entity.getId());

       if (entity.getCategory() != null){
        model.setCategory(entity.getCategory());
       }
       if (entity.getCategoryTw() != null){
        model.setCategoryTw(entity.getCategoryTw());
       }
       if (entity.getCategoryEn() != null){
        model.setCategoryEn(entity.getCategoryEn());
       }
        BizAgentApplicationCategoryModel saveModel =  this.repository.save(model);
        return BizAgentApplicationCategoryConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception{
        Assert.notNull(id);
        BizAgentApplicationCategoryModel model =  this.repository.get(id);
        if (model != null){
       }
   }
    
}