package cn.com.poc.agent_application.service.impl;

import cn.com.poc.agent_application.query.MemberCollectQueryCondition;
import cn.com.poc.agent_application.query.MemberCollectQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizMemberAgentApplicationCollectService;
import cn.com.poc.agent_application.model.BizMemberAgentApplicationCollectModel;
import cn.com.poc.agent_application.entity.BizMemberAgentApplicationCollectEntity;
import cn.com.poc.agent_application.convert.BizMemberAgentApplicationCollectConvert;
import cn.com.poc.agent_application.repository.BizMemberAgentApplicationCollectRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizMemberAgentApplicationCollectServiceImpl extends BaseServiceImpl
        implements BizMemberAgentApplicationCollectService {

    @Resource
    private BizMemberAgentApplicationCollectRepository repository;

    public BizMemberAgentApplicationCollectEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizMemberAgentApplicationCollectModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMemberAgentApplicationCollectConvert.modelToEntity(model);
    }

    @Override
    public BizMemberAgentApplicationCollectEntity getByAgentId(String agentId) throws Exception {
        BizMemberAgentApplicationCollectModel model = new BizMemberAgentApplicationCollectModel();
        model.setAgentId(agentId);
        model.setIsDeleted("N");
        List<BizMemberAgentApplicationCollectModel> models = this.repository.findByExample(model);
        if (!models.isEmpty()) {
            return BizMemberAgentApplicationCollectConvert.modelToEntity(models.get(0));
        }
        return null;
    }


    public List<BizMemberAgentApplicationCollectEntity> findByExample(BizMemberAgentApplicationCollectEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizMemberAgentApplicationCollectEntity> result = new ArrayList<BizMemberAgentApplicationCollectEntity>();
        BizMemberAgentApplicationCollectModel model = new BizMemberAgentApplicationCollectModel();
        if (example != null) {
            model = BizMemberAgentApplicationCollectConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberAgentApplicationCollectModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberAgentApplicationCollectConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberAgentApplicationCollectEntity save(BizMemberAgentApplicationCollectEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberAgentApplicationCollectModel model = BizMemberAgentApplicationCollectConvert.entityToModel(entity);
        BizMemberAgentApplicationCollectModel saveModel = this.repository.save(model);
        return BizMemberAgentApplicationCollectConvert.modelToEntity(saveModel);
    }

    public BizMemberAgentApplicationCollectEntity update(BizMemberAgentApplicationCollectEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMemberAgentApplicationCollectModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getAgentId() != null) {
            model.setAgentId(entity.getAgentId());
        }
        if (entity.getIsCollect() != null) {
            model.setIsCollect(entity.getIsCollect());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        BizMemberAgentApplicationCollectModel saveModel = this.repository.save(model);
        return BizMemberAgentApplicationCollectConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizMemberAgentApplicationCollectModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

    @Override
    public List<MemberCollectQueryItem> queryMemberCollect(MemberCollectQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, MemberCollectQueryItem.class, pagingInfo);
    }
}