package cn.com.poc.common.dto;


import cn.com.poc.support.sms.constant.SmsConstant;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

/**
 * @author Focan.Zhong
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SmsDto implements Serializable {

    private SmsConstant.Channel channel;

    /**
     * 手机号
     */
    private String mobilePhone;
    /**
     * 手机验证码
     */
    private String smsCode;

    //验证码请求体
    /**
     * verifyCodeType String 是 短信验证码类型(必传)
     * * 1.发送快捷登录或注册短信，
     * * 2.发送语音短信，
     * * 4.重置密码发送短信，
     * * 5.风控发送短信
     * verifyImgType String 是 图形、滑块验证类型（必传） 2.图形验证码，3.滑块验证
     * verifyImgCode String 否  图形验证码（verifyImgType=2时必填）
     * uniqueFlag String 是 滑块唯一标识（verifyImgType=3时必填）
     * xPercent String 是 滑块横坐标所占比例 （verifyImgType=3时必填） @mock=1
     */
    private String verifyCodeType;
    private String verifyImgType;
    private String verifyImgCode;
    private String uniqueFlag;
    private String xPercent;

    /**
     * 滑块开关
     */
    private String captchaSwitch;
    /**
     * 滑块大图
     */
    private String oriCopyImages;
    /**
     * 滑块图
     */
    private String slideImages;

    public SmsConstant.Channel getChannel() {
        return channel;
    }

    public void setChannel(SmsConstant.Channel channel) {
        this.channel = channel;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getSmsCode() {
        return smsCode;
    }

    public void setSmsCode(String smsCode) {
        this.smsCode = smsCode;
    }

    public String getVerifyCodeType() {
        return verifyCodeType;
    }

    public void setVerifyCodeType(String verifyCodeType) {
        this.verifyCodeType = verifyCodeType;
    }

    public String getVerifyImgType() {
        return verifyImgType;
    }

    public void setVerifyImgType(String verifyImgType) {
        this.verifyImgType = verifyImgType;
    }

    public String getVerifyImgCode() {
        return verifyImgCode;
    }

    public void setVerifyImgCode(String verifyImgCode) {
        this.verifyImgCode = verifyImgCode;
    }

    public String getUniqueFlag() {
        return uniqueFlag;
    }

    public void setUniqueFlag(String uniqueFlag) {
        this.uniqueFlag = uniqueFlag;
    }

    public String getxPercent() {
        return xPercent;
    }

    public void setxPercent(String xPercent) {
        this.xPercent = xPercent;
    }

    public String getCaptchaSwitch() {
        return captchaSwitch;
    }

    public void setCaptchaSwitch(String captchaSwitch) {
        this.captchaSwitch = captchaSwitch;
    }

    public String getOriCopyImages() {
        return oriCopyImages;
    }

    public void setOriCopyImages(String oriCopyImages) {
        this.oriCopyImages = oriCopyImages;
    }

    public String getSlideImages() {
        return slideImages;
    }

    public void setSlideImages(String slideImages) {
        this.slideImages = slideImages;
    }
}
