package cn.com.poc.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.io.UnsupportedEncodingException;

public class MD5Utils {
    /*** 编码 */
    public static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("签名过程中出现错误,指定的编码集不对,您目前指定的编码 集是:" + charset);
        }
    }

    /*** 获取签名 */
    public static String getSign(String text, String input_charset) {
        try {
            if (StringUtils.isBlank(input_charset)) {
                input_charset = "UTF-8";
            }
            String sign = org.apache.commons.codec.digest.DigestUtils.md5Hex(getContentBytes(text, input_charset));
            return sign;
        } catch (Exception e) {
            return "";
        }
    }
}
