package cn.com.poc.data_analyze.aggregate;

import cn.com.poc.data_analyze.constants.DataAnalyzeChannelEnum;
import cn.com.poc.data_analyze.constants.DataAnalyzeTypeEnum;

import java.math.BigDecimal;

/**
 * 应用数据分析-数据上报服务
 *
 * @author alex.yao
 * @date 2024/12/10
 */
public interface DataAnalyzeReportService {

    /**
     * 数据上报- 积分使用情况
     *
     * @param memberId
     * @param point
     * @param type
     * @param relationId
     * @param channel
     */
    void dataReportByPoint(Long memberId, BigDecimal point, DataAnalyzeTypeEnum type, String relationId, DataAnalyzeChannelEnum channel);

    /**
     * 数据上报- 应用对话次数记录
     *
     * @param memberId
     * @param type
     * @param relationId
     * @param channel
     */
    void dataReportByDialogue(Long memberId, DataAnalyzeTypeEnum type, String relationId, DataAnalyzeChannelEnum channel);

    /**
     * 数据上报-聚合上报【对话次数+积分使用情况】
     *
     * @param agentId 应用ID
     * @param channel 渠道
     * @param userId 用户ID
     * @param pointDeductionNum 积分扣除数量-单位分
     */
    boolean dataReport(String agentId, DataAnalyzeChannelEnum channel, Long userId, Long pointDeductionNum);
}
