package cn.com.poc.data_analyze.convert;	

import cn.com.poc.data_analyze.model.BizDataAnalyzeCollectModel;
import cn.com.poc.data_analyze.entity.BizDataAnalyzeCollectEntity;
import cn.com.poc.data_analyze.dto.BizDataAnalyzeCollectDto;


public class BizDataAnalyzeCollectConvert {

    public static BizDataAnalyzeCollectEntity modelToEntity(BizDataAnalyzeCollectModel model){
        BizDataAnalyzeCollectEntity entity = new BizDataAnalyzeCollectEntity();
        entity.setId(model.getId());
        entity.setRelationId(model.getRelationId());
        entity.setType(model.getType());
        entity.setChannel(model.getChannel());
        entity.setTotalPoints(model.getTotalPoints());
        entity.setUsageCount(model.getUsageCount());
        entity.setUsersCount(model.getUsersCount());
        entity.setDataDate(model.getDataDate());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizDataAnalyzeCollectModel entityToModel(BizDataAnalyzeCollectEntity entity){
        BizDataAnalyzeCollectModel model = new BizDataAnalyzeCollectModel();
        model.setId(entity.getId());
        model.setRelationId(entity.getRelationId());
        model.setType(entity.getType());
        model.setChannel(entity.getChannel());
        model.setTotalPoints(entity.getTotalPoints());
        model.setUsageCount(entity.getUsageCount());
        model.setUsersCount(entity.getUsersCount());
        model.setDataDate(entity.getDataDate());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }
    
    public static BizDataAnalyzeCollectDto entityToDto(BizDataAnalyzeCollectEntity entity){
        BizDataAnalyzeCollectDto dto = new BizDataAnalyzeCollectDto();
        dto.setId(entity.getId());
        dto.setRelationId(entity.getRelationId());
        dto.setType(entity.getType());
        dto.setChannel(entity.getChannel());
        dto.setTotalPoints(entity.getTotalPoints());
        dto.setUsageCount(entity.getUsageCount());
        dto.setUsersCount(entity.getUsersCount());
        dto.setDataDate(entity.getDataDate());
        dto.setIsDeleted(entity.getIsDeleted());
        dto.setCreator(entity.getCreator());
        dto.setCreatedTime(entity.getCreatedTime());
        dto.setModifier(entity.getModifier());
        dto.setModifiedTime(entity.getModifiedTime());
        dto.setSysVersion(entity.getSysVersion());
        return dto;
    }

    public static BizDataAnalyzeCollectEntity dtoToEntity(BizDataAnalyzeCollectDto dto){
        BizDataAnalyzeCollectEntity entity = new BizDataAnalyzeCollectEntity();
        entity.setId(dto.getId());
        entity.setRelationId(dto.getRelationId());
        entity.setType(dto.getType());
        entity.setChannel(dto.getChannel());
        entity.setTotalPoints(dto.getTotalPoints());
        entity.setUsageCount(dto.getUsageCount());
        entity.setUsersCount(dto.getUsersCount());
        entity.setDataDate(dto.getDataDate());
        entity.setIsDeleted(dto.getIsDeleted());
        entity.setCreator(dto.getCreator());
        entity.setCreatedTime(dto.getCreatedTime());
        entity.setModifier(dto.getModifier());
        entity.setModifiedTime(dto.getModifiedTime());
        entity.setSysVersion(dto.getSysVersion());
        return entity;
    }
}