WITH RECURSIVE DateRange AS (
    SELECT :startDate AS date_value
    UNION ALL
    SELECT DATE_ADD(date_value, INTERVAL 1 DAY)
    FROM DateRange
    WHERE DATE_ADD(date_value, INTERVAL 1 DAY) <= :endDate
),
pointData AS (
    SELECT 
        DATE(datetime) AS consume_date, 
        SUM(point_num) AS total_points
    FROM 
        biz_data_analyze_point_record
    WHERE 1=1
        << and member_id = :memberId >>
        << and datetime >= :startDate and datetime <=  :endDate >>
        << and channel = :channel >>
    GROUP BY 
        DATE(datetime)
)
SELECT 
    dr.date_value AS dialogue_date,
    COALESCE(pd.total_points, 0) AS total_points
FROM
    DateRange dr
LEFT JOIN
    pointData pd ON dr.date_value = pd.consume_date
ORDER BY 
    dr.date_value