SELECT
    COALESCE(SUM(CASE WHEN DATE(datetime) = CURDATE() THEN point_num ELSE NULL END), 0) AS today_total_points,
    COALESCE(SUM(CASE WHEN DATE(datetime) = CURDATE() - INTERVAL 1 DAY THEN point_num ELSE NULL END), 0) AS yesterday_total_points,
    COALESCE(SUM(CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE(), 1) THEN point_num ELSE NULL END), 0) AS week_total_points,
    COALESCE(SUM(CASE WHEN YEARWEEK(datetime, 1) = YEARWEEK(CURDATE() - INTERVAL 1 WEEK, 1) THEN point_num ELSE NULL END), 0) AS last_week_total_points,
    COALESCE(SUM(CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE) AND MONTH(datetime) = MONTH(CURRENT_DATE) THEN point_num ELSE NULL END), 0) AS month_total_points,
    COALESCE(SUM(CASE WHEN YEAR(datetime) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) AND MONTH(datetime) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH) THEN point_num ELSE NULL END), 0) AS last_month_total_points
FROM biz_data_analyze_point_record
WHERE 1=1
<<and relation_id = :relationId >>
<<and channel in (:channels)>>