package cn.com.poc.equity.domain;


import cn.com.poc.equity.constants.EquityEnum;

import java.math.BigDecimal;


/**
 * 应用权益
 * 应用数上限
 * 知识库数上限
 *
 * @alex.yao
 */
public class AgentEquity {
    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 积分数
     */
    private Long points;

    /**
     * 应用数上限
     */
    private Integer agentNum;

    /**
     * 知识库上限
     */
    private Integer knowledgeNum;

    /**
     * 有效期单位
     */
    private EquityEnum.VALIDITY_UNIT validityUnit;

    public Integer getAgentNum() {
        return agentNum;
    }

    public void setAgentNum(Integer agentNum) {
        this.agentNum = agentNum;
    }

    public Integer getKnowledgeNum() {
        return knowledgeNum;
    }

    public void setKnowledgeNum(Integer knowledgeNum) {
        this.knowledgeNum = knowledgeNum;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Long getPoints() {
        return points;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public EquityEnum.VALIDITY_UNIT getValidityUnit() {
        return validityUnit;
    }

    public void setValidityUnit(EquityEnum.VALIDITY_UNIT validityUnit) {
        this.validityUnit = validityUnit;
    }
}
