package cn.com.poc.equity.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.equity.service.BizMemberEquityService;
import cn.com.poc.equity.model.BizMemberEquityModel;
import cn.com.poc.equity.entity.BizMemberEquityEntity;
import cn.com.poc.equity.convert.BizMemberEquityConvert;
import cn.com.poc.equity.repository.BizMemberEquityRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizMemberEquityServiceImpl extends BaseServiceImpl
        implements BizMemberEquityService {

    @Resource
    private BizMemberEquityRepository repository;

    public BizMemberEquityEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberEquityModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMemberEquityConvert.modelToEntity(model);
    }

    @Override
    public BizMemberEquityEntity getByMemberId(Long memberId) throws Exception {
        Assert.notNull(memberId);
        BizMemberEquityModel bizMemberEquityModel = new BizMemberEquityModel();
        bizMemberEquityModel.setMemberId(memberId);
        bizMemberEquityModel.setIsDeleted("N");
        List<BizMemberEquityModel> models = this.repository.findByExample(bizMemberEquityModel, null);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizMemberEquityConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public List<BizMemberEquityEntity> findByExample(BizMemberEquityEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizMemberEquityEntity> result = new ArrayList<BizMemberEquityEntity>();
        BizMemberEquityModel model = new BizMemberEquityModel();
        if (example != null) {
            model = BizMemberEquityConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberEquityModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberEquityConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberEquityEntity save(BizMemberEquityEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberEquityModel model = BizMemberEquityConvert.entityToModel(entity);
        BizMemberEquityModel saveModel = this.repository.save(model);
        return BizMemberEquityConvert.modelToEntity(saveModel);
    }

    public BizMemberEquityEntity update(BizMemberEquityEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMemberEquityModel model = this.repository.get(entity.getId());

        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getEquityLevel() != null) {
            model.setEquityLevel(entity.getEquityLevel());
        }
        if (entity.getExpiredDate() != null) {
            model.setExpiredDate(entity.getExpiredDate());
        }
        if (entity.getEquityConfig() != null) {
            model.setEquityConfig(entity.getEquityConfig());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizMemberEquityModel saveModel = this.repository.save(model);
        return BizMemberEquityConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberEquityModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}