package cn.com.poc.expose.aggregate.impl;

import cn.com.poc.agent_application.constant.AgentApplicationConstants;
import cn.com.poc.agent_application.entity.BizAgentApplicationInfoEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationInfoService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.data_analyze.constants.DataAnalyzeTimeRangeEnum;
import cn.com.poc.data_analyze.domain.DataAnalyzeTimeRange;
import cn.com.poc.data_analyze.domain.TimeRange;
import cn.com.poc.data_analyze.query.*;
import cn.com.poc.data_analyze.service.BizDataAnalyzeDialogueRecordService;
import cn.com.poc.data_analyze.service.BizDataAnalyzePointRecordService;
import cn.com.poc.expose.aggregate.DataStatisticsService;
import cn.com.poc.expose.entity.PlatformAgentUsageDetailEntity;
import cn.com.poc.expose.entity.PlatformAgentUsageEntity;
import cn.com.poc.expose.entity.PlatformPointUsageEntity;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * @author alex.yao
 * @date 2024/12/23
 */
@Service
public class DataStatisticsServiceImpl implements DataStatisticsService {

    @Resource
    private BizDataAnalyzePointRecordService bizDataAnalyzePointRecordService;

    @Resource
    private BizDataAnalyzeDialogueRecordService bizDataAnalyzeDialogueRecordService;

    @Resource
    private BizAgentApplicationInfoService bizAgentApplicationInfoService;

    @Override
    public PlatformPointUsageEntity platformPointUsage(Long memberId, List<String> channels) {
        MemberPointUsageOverallQueryCondition memberPointUsageOverallQueryCondition = new MemberPointUsageOverallQueryCondition();
        memberPointUsageOverallQueryCondition.setMemberId(memberId);
        memberPointUsageOverallQueryCondition.setChannels(channels);
        List<MemberPointUsageOverallQueryItem> items = bizDataAnalyzePointRecordService.memberPointUsageOverallQuery(memberPointUsageOverallQueryCondition, null);
        PlatformPointUsageEntity platformPointUsageEntity = new PlatformPointUsageEntity();
        if (CollectionUtils.isNotEmpty(items)) {
            MemberPointUsageOverallQueryItem memberPointUsageOverallQueryItem = items.get(0);
            platformPointUsageEntity.setToday(memberPointUsageOverallQueryItem.getTodayTotalPoints());
            platformPointUsageEntity.setWeek(memberPointUsageOverallQueryItem.getWeekTotalPoints());
            platformPointUsageEntity.setMonth(memberPointUsageOverallQueryItem.getMonthTotalPoints());
            platformPointUsageEntity.setYear(memberPointUsageOverallQueryItem.getYearTotalPoints());
        } else {
            platformPointUsageEntity.setToday(0D);
            platformPointUsageEntity.setWeek(0D);
            platformPointUsageEntity.setMonth(0D);
            platformPointUsageEntity.setYear(0D);
        }
        return platformPointUsageEntity;
    }

    @Override
    public Map<String, List<MemberPointUsageTrendQueryItem>> platformPointTrend(Long memberId, List<String> channels, DataAnalyzeTimeRange timeRange) {
        Map<String, List<MemberPointUsageTrendQueryItem>> result = new TreeMap<>();
        TimeRange timeRangeResult = DataAnalyzeTimeRangeEnum.calculateTimeRange(timeRange);
        String endTime = timeRangeResult.getEndTime();
        String startTime = timeRangeResult.getStartTime();
        for (String channel : channels) {
            MemberPointUsageTrendQueryCondition memberPointUsageTrendQueryCondition = new MemberPointUsageTrendQueryCondition();
            memberPointUsageTrendQueryCondition.setStartDate(startTime);
            memberPointUsageTrendQueryCondition.setEndDate(endTime);
            memberPointUsageTrendQueryCondition.setMemberId(memberId);
            memberPointUsageTrendQueryCondition.setChannel(channel);
            List<MemberPointUsageTrendQueryItem> items = bizDataAnalyzePointRecordService.memberPointUsageTrendQuery(memberPointUsageTrendQueryCondition, null);
            result.put(channel, items);
        }
        return result;
    }


    @Override
    public PlatformAgentUsageEntity platformAgentUsage(Long memberId, List<String> channels) {
        BizAgentApplicationInfoEntity bizAgentApplicationInfoEntity = new BizAgentApplicationInfoEntity();
        bizAgentApplicationInfoEntity.setMemberId(memberId.intValue());
        bizAgentApplicationInfoEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizAgentApplicationInfoEntity> applicationInfoEntities = bizAgentApplicationInfoService.findByExample(bizAgentApplicationInfoEntity, null);
        long createCount = applicationInfoEntities.size();
        long publishCount = applicationInfoEntities.stream().filter(entity -> AgentApplicationConstants.AGENT_PUBLISH_STATUS.PUBLISH.equals(entity.getAgentPublishStatus())).count();
        long unPublishCount = createCount - publishCount;
        Long memberUsageCount = bizDataAnalyzeDialogueRecordService.memberUsageCount(memberId);
        PlatformAgentUsageEntity platformAgentUsageEntity = new PlatformAgentUsageEntity();
        platformAgentUsageEntity.setCreateCount(createCount);
        platformAgentUsageEntity.setUsageCount(memberUsageCount);
        platformAgentUsageEntity.setUnPublishCount(unPublishCount);
        platformAgentUsageEntity.setPublishCount(publishCount);
        return platformAgentUsageEntity;
    }

    @Override
    public List<PlatformAgentUsageDetailEntity> platformAgentUsageDetail(Long memberId, DataAnalyzeTimeRange timeRange, PagingInfo pagingInfo) {
        TimeRange timeRangeResult = DataAnalyzeTimeRangeEnum.calculateTimeRange(timeRange);
        String endTime = timeRangeResult.getEndTime();
        String startTime = timeRangeResult.getStartTime();
        MemberAgentUsageDetailsQueryCondition memberAgentUsageDetailsQueryCondition = new MemberAgentUsageDetailsQueryCondition();
        memberAgentUsageDetailsQueryCondition.setMemberId(memberId);
        memberAgentUsageDetailsQueryCondition.setStartDate(startTime);
        memberAgentUsageDetailsQueryCondition.setEndDate(endTime);

        List<MemberAgentUsageDetailsQueryItem> items = bizDataAnalyzeDialogueRecordService.memberAgentUsageDetailsQuery(memberAgentUsageDetailsQueryCondition, pagingInfo);
        List<PlatformAgentUsageDetailEntity> result = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(items)) {
            for (MemberAgentUsageDetailsQueryItem item : items) {
                PlatformAgentUsageDetailEntity platformAgentUsageDetailEntity = new PlatformAgentUsageDetailEntity();
                platformAgentUsageDetailEntity.setAgentTitle(item.getAgentTitle());
                platformAgentUsageDetailEntity.setOwner(item.getOwner());
                platformAgentUsageDetailEntity.setPublishStatus(item.getPublishStatus());
                platformAgentUsageDetailEntity.setTotalPoint(BigDecimal.valueOf(item.getTotalPoints()).setScale(2, RoundingMode.HALF_UP).doubleValue());
                platformAgentUsageDetailEntity.setUsageCount(item.getUsageCount());
                platformAgentUsageDetailEntity.setLastUsageTime(DateUtils.formatDate(item.getLastUsageTime(), DateUtils.yyyy_MM_dd_HH_mm_ss));
                result.add(platformAgentUsageDetailEntity);
            }
        }
        return result;
    }
}
