package cn.com.poc.expose.rest;

import cn.com.poc.expose.dto.model_link_api.CompletionsDto;
import cn.com.poc.expose.dto.model_link_api.CreateConversationDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Model-Link Api 接口服务
 *
 * @author alex.yao
 * @date 2024/12/23
 */
@Permission(Access.Anonymous)
public interface ModelLinkRest extends BaseRest {


    /**
     * 新建对话ID
     * 有效期为7天，过期后将无法使用。
     *
     * @return 对话ID
     */
    String conversation(@RequestBody CreateConversationDto dto, HttpServletRequest httpServletRequest) throws Exception;

    /**
     * API-对话
     *
     * @param dto
     * @param httpServletRequest
     * @param httpServletResponse
     */
    void completions(@RequestBody CompletionsDto dto, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 上传文件
     * 该接口用于在对话中上传文件供大模型处理，文件的有效期为7天并且不超过对话的有效期。一次只能上传一个文件。
     *
     * @param agentId            Agent ID
     * @param conversationId     对话ID
     * @param file               文件
     * @param httpServletRequest
     * @return 文件ID
     */
    String uploadFile(@RequestParam String agentId, @RequestParam String conversationId, @RequestParam MultipartFile file, HttpServletRequest httpServletRequest) throws Exception;


}
