package cn.com.poc.expose.websocket.exception;

import cn.com.yict.framemax.core.exception.ErrorCoded;
import org.slf4j.MDC;

import java.io.Serializable;

/**
 * @author alex.yao
 * @date 2023/12/15
 **/
public class WebsocketException extends RuntimeException implements ErrorCoded {

    private static final long serialVersionUID = 2332618265610125980L;

    private final String LOG_KEY = "log_trace_id";

    private Serializable errorCode = -1;

    private String traceId;

    public WebsocketException() {
        super();
    }

    public WebsocketException(Throwable cause) {
        super(cause);
    }

    public WebsocketException(String message) {
        super(message);
        this.traceId = MDC.get(LOG_KEY);
    }

    public WebsocketException(Serializable code, String message) {
        super(message);
        this.errorCode = code;
        this.traceId = MDC.get(LOG_KEY);
    }

    public WebsocketException(String message, String traceId) {
        super(message);
        this.traceId = traceId;
    }

    public WebsocketException(Serializable code, String message, String traceId) {
        super(message);
        this.errorCode = code;
        this.traceId = traceId;
    }

    @Override
    public Serializable getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public String toString() {
        return "{\"code\":" + "\"" + errorCode + "\"  ,\"message\":" + "\"" + super.getMessage() + "\"  ,\"traceId\":" + "\"" + traceId + "\"}";
    }
}
