package cn.com.poc.formreport.strategy;

import cn.com.poc.data_analyze.entity.AgentDataAnalyzeApiChannelEntity;
import cn.com.poc.expose.aggregate.AgentDataAnalyzeService;
import cn.com.poc.formreport.FormReportRequest;
import cn.com.poc.formreport.entity.ApiChannelReportEntity;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Agent应用 API渠道-积分使用数据
 *
 * @author alex.yao
 * @date 2024/12/20
 */
@Component
public class AgentDataAnalyzeApiChannelFormReportStrategy extends AbstractFormReportStrategy implements FormReportStrategy {

    @Resource
    private AgentDataAnalyzeService agentDataAnalyzeService;


    @Override
    public List<Object> getFormReportData(FormReportRequest reportRequest) throws Exception {
        List<AgentDataAnalyzeApiChannelEntity> analyzeApiChannelEntities = agentDataAnalyzeService.getAgentApiChannelPointCount(reportRequest.getAgentId(), reportRequest.getTimeRange());
        return analyzeApiChannelEntities.stream().map(value -> {
            ApiChannelReportEntity apiChannelReportEntity = new ApiChannelReportEntity();
            apiChannelReportEntity.setDateTime(value.getDateTime());
            apiChannelReportEntity.setCount(BigDecimal.valueOf(value.getCount()).setScale(2, RoundingMode.HALF_UP).doubleValue());
            return apiChannelReportEntity;
        }).collect(Collectors.toList());
    }

    @Override
    public Class getExcelEntityClass() {
        return ApiChannelReportEntity.class;
    }

    @Override
    public String getExcelName(FormReportRequest reportRequest) throws Exception {
        return "Agent-Api-Channel";
    }
}
