package cn.com.poc.knowledge.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_knowledge_train_log
 * 知识库训练日志
 */
@Entity
@Table(name = "biz_knowledge_train_log")
@DynamicInsert
@DynamicUpdate
public class BizKnowledgeTrainLogModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *主键
    */ 
    private Integer id;
    
    @Column(name = "id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Integer getId(){
        return this.id;
    }
    
    public void setId(Integer id){
        this.id = id;
        super.addValidField("id");
    }
    
  
    /** kd_id
    *biz_knowledge_document 主键ID
    */ 
    private Integer kdId;
    
    @Column(name = "kd_id",length = 10)
    public Integer getKdId(){
        return this.kdId;
    }
    
    public void setKdId(Integer kdId){
        this.kdId = kdId;
        super.addValidField("kdId");
    }
    
  
    /** timestamp
    *时间
    */ 
    private Long timestamp;
    
    @Column(name = "timestamp",length = 19)
    public Long getTimestamp(){
        return this.timestamp;
    }
    
    public void setTimestamp(Long timestamp){
        this.timestamp = timestamp;
        super.addValidField("timestamp");
    }
    
  
    /** train_status
    *训练状态 SUCCESS-成功，FAIL-失败
    */ 
    private String trainStatus;
    
    @Column(name = "train_status",length = 100)
    public String getTrainStatus(){
        return this.trainStatus;
    }
    
    public void setTrainStatus(String trainStatus){
        this.trainStatus = trainStatus;
        super.addValidField("trainStatus");
    }
    
  
    /** failure_log
    *失败日志
    */ 
    private String failureLog;
    
    @Column(name = "failure_log",length = 65535)
    public String getFailureLog(){
        return this.failureLog;
    }
    
    public void setFailureLog(String failureLog){
        this.failureLog = failureLog;
        super.addValidField("failureLog");
    }
    
  
    /** is_deleted
    *是否删除
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 50)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 50)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}