package cn.com.poc.knowledge.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.knowledge.convert.KnowledgeDocumentConvert;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.model.BizKnowledgeDocumentModel;
import cn.com.poc.knowledge.query.KnowledgeQueryCondition;
import cn.com.poc.knowledge.query.KnowledgeQueryItem;
import cn.com.poc.knowledge.repository.BizKnowledgeDocumentRepository;
import cn.com.poc.knowledge.service.BizKnowledgeDocumentService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizKnowledgeDocumentServiceImpl extends BaseServiceImpl
        implements BizKnowledgeDocumentService {

    @Resource
    private BizKnowledgeDocumentRepository repository;

    @Override
    public BizKnowledgeDocumentEntity get(Integer kdId) {
        BizKnowledgeDocumentModel bizKnowledgeDocumentModel = this.repository.get(kdId);
        return KnowledgeDocumentConvert.modelToEntity(bizKnowledgeDocumentModel);
    }

    @Override
    public List<BizKnowledgeDocumentEntity> findByExample(BizKnowledgeDocumentEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizKnowledgeDocumentEntity> result = new ArrayList<>();
        BizKnowledgeDocumentModel model = KnowledgeDocumentConvert.entityToModel(example);
        model.setIsDeleted(CommonConstant.IsDeleted.N);//只能查询未删除
        List<BizKnowledgeDocumentModel> models = this.repository.findByExample(model, pagingInfo);
        if (!CollectionUtils.isEmpty(models)) {
            result = models.stream().map(KnowledgeDocumentConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public BizKnowledgeDocumentEntity save(BizKnowledgeDocumentEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.isTrue(entity.getKdId() == null, "cannot save ,because id is not null");
        BizKnowledgeDocumentModel model = KnowledgeDocumentConvert.entityToModel(entity);
        BizKnowledgeDocumentModel saveModel = this.repository.save(model);
        return KnowledgeDocumentConvert.modelToEntity(saveModel);
    }

    @Override
    public BizKnowledgeDocumentEntity update(Integer kdId, BizKnowledgeDocumentEntity entity) throws Exception {
        Assert.notNull(kdId, "cannot update,because id is null");
        Assert.notNull(entity, "update source cannot null");
        BizKnowledgeDocumentModel bizKnowledgeDocumentModel = this.repository.get(kdId);
        Assert.notNull(bizKnowledgeDocumentModel, "cannot find");
        BeanUtil.copyProperties(entity, bizKnowledgeDocumentModel, new CopyOptions() {{
            setIgnoreNullValue(true);
        }});
        if (null != entity.getSegmentationConfig()) {
            String config = JsonUtils.serialize(entity.getSegmentationConfig());
            bizKnowledgeDocumentModel.setSegmentationConfig(config);
        }
        BizKnowledgeDocumentModel updateModel = this.repository.save(bizKnowledgeDocumentModel);
        return KnowledgeDocumentConvert.modelToEntity(updateModel);
    }

    @Override
    public Boolean deleted(Integer kdId) {
        Assert.notNull(kdId);
        BizKnowledgeDocumentModel bizKnowledgeDocumentModel = this.repository.get(kdId);
        if (null != bizKnowledgeDocumentModel) {
            bizKnowledgeDocumentModel.setIsEnable(CommonConstant.IsDeleted.N);
            bizKnowledgeDocumentModel.setIsDeleted(CommonConstant.IsDeleted.Y);
            this.repository.save(bizKnowledgeDocumentModel);
        }
        return true;
    }

    @Override
    public List<KnowledgeQueryItem> searchKnowledge(String searchDocumentName, String trainStatus, String memberId, String documentName, List<Integer> kdIds, PagingInfo pagingInfo) {
        KnowledgeQueryCondition condition = new KnowledgeQueryCondition();
        condition.setMemberId(memberId);
        condition.setDocumentName(documentName);
        condition.setTrainStatus(trainStatus);
        condition.setSearchDocumentName(searchDocumentName);
        condition.setKdIds(kdIds);
        return this.sqlDao.query(condition, KnowledgeQueryItem.class, pagingInfo);
    }
}