package cn.com.poc.thirdparty.resource.demand.member.api;

import cn.com.poc.common.utils.http.LocalHttpClient;
import cn.com.poc.thirdparty.resource.demand.member.entity.DemandMemberResult;
import cn.com.poc.thirdparty.resource.demand.ai.route.DgtoolsApiRoute;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author alex.yao
 * @date 2023/6/1
 **/
@Component
public class DemandMemberApi {


    @Value("${dgtools.domain.url}")
    private String dgtoolsDomainurl;

    /**
     * 创建中台会员
     */
    public String createDemandMember(String token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(dgtoolsDomainurl + DgtoolsApiRoute.BASE_URL + DgtoolsApiRoute.MemberPlatform.CRAETE_DEMAND_MEMBER)
                .setHeader(DgtoolsApiRoute.JSON_HEADER)
                .setHeader(DgtoolsApiRoute.HEADER_X_PLATFORM_AUTHORIZATION, token)
                .setHeader(DgtoolsApiRoute.MEMBER_HEADER)
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, String.class);
    }

    /**
     * 查询中台会员
     */
    public DemandMemberResult searchDemandMember(String demandMemberId, String token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post()
                .setUri(dgtoolsDomainurl + DgtoolsApiRoute.BASE_URL + DgtoolsApiRoute.MemberPlatform.SEARCH_DEMAND_MEMBER)
                .setHeader(DgtoolsApiRoute.JSON_HEADER)
                .setHeader(DgtoolsApiRoute.HEADER_X_PLATFORM_AUTHORIZATION, token)
                .setHeader(DgtoolsApiRoute.MEMBER_HEADER)
                .addParameter("memberId", demandMemberId)
                .build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, DemandMemberResult.class);
    }


}
