package cn.com.poc.thirdparty.resource.demand.pay.dto;

import cn.com.poc.thirdparty.resource.demand.pay.entity.RetainInformation;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @author Roger Wu
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DgtoolsPayOrderDto {

    /**
     * prepay_sn
     * 预付款号
     */
    private String payOrderSn;

    public String getPayOrderSn() {
        return payOrderSn;
    }

    public void setPayOrderSn(String payOrderSn) {
        this.payOrderSn = payOrderSn;
    }



    /**
     * pay_order_type
     * 付款订单类型
     */
    private String payOrderType;

    public String getPayOrderType() {
        return payOrderType;
    }

    public void setPayOrderType(String payOrderType) {
        this.payOrderType = payOrderType;
    }

    /**
     * amount
     * 订单金额(分)
     */
    private Integer amount;

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }


    /**
     * total_amount
     * 订单金额(分)
     */
    private Integer totalAmount;

    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }


    /**
     * paid_amount
     * 已付金额(分)
     */
    private Integer paidAmount;

    public Integer getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(Integer paidAmount) {
        this.paidAmount = paidAmount;
    }


    /**
     * need_pay_amount
     * 订单待付金额(分)
     */
    private Integer needPayAmount;

    public Integer getNeedPayAmount() {
        return this.needPayAmount;
    }

    public void setNeedPayAmount(Integer needPayAmount) {
        this.needPayAmount = needPayAmount;
    }


    /**
     * currency
     * 币种
     */
    private String currency;

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * retain_information
     * 留资
     */
    private RetainInformation retainInformation;

    public RetainInformation getRetainInformation() {
        return retainInformation;
    }

    public void setRetainInformation(RetainInformation retainInformation) {
        this.retainInformation = retainInformation;
    }

    /**
     * desc
     * 描述
     */
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * desc
     * 描述
     */
    private Integer memberId;

    public Integer getMemberId() {
        return memberId;
    }

    public void setMemberId(Integer memberId) {
        this.memberId = memberId;
    }

    /**
     * marketing_game_flow_no
     * 游戏流水号
     */
    private String marketingGameFlowNo;

    public String getMarketingGameFlowNo() {
        return marketingGameFlowNo;
    }

    public void setMarketingGameFlowNo(String marketingGameFlowNo) {
        this.marketingGameFlowNo = marketingGameFlowNo;
    }


    /**
     * order_status
     * 支付状态:
     * NoPayment-待支付;
     * Refunding-退款中;
     * Paid-已付款;
     * Cancel-已取消;
     */
    private String orderStatus;

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    /**
     * pay_status
     * 支付状态:
     * NoPayment-待支付;
     * Refunding-退款中;
     * Paid-已付款;
     * Cancel-已取消;
     */
    private String payStatus;

    public String getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }


    /**
     * pay_time
     * 付款时间
     */
    private java.util.Date payTime;

    public java.util.Date getPayTime() {
        return this.payTime;
    }

    public void setPayTime(java.util.Date payTime) {
        this.payTime = payTime;
    }


    /**
     * cancel_time
     * 订单取消时间
     */
    private java.util.Date cancelTime;

    public java.util.Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(java.util.Date cancelTime) {
        this.cancelTime = cancelTime;
    }


    /**
     * corp_info_id
     * 企业号
     */
    private Integer corpInfoId;

    public Integer getCorpInfoId() {
        return this.corpInfoId;
    }

    public void setCorpInfoId(Integer corpInfoId) {
        this.corpInfoId = corpInfoId;
    }


    /**
     * merchant_id
     * 商家号
     */
    private Integer merchantId;

    public Integer getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(Integer merchantId) {
        this.merchantId = merchantId;
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
    }
}