package cn.com.poc.thirdparty.resource.demand.pay.rest;

import cn.com.poc.thirdparty.resource.demand.pay.dto.PayOrderStatusDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author Roger Wu
 */
@Permission(Access.Safety)
public interface PayRest extends BaseRest {

    /**
     * 发起支付
     *
     * @param payChannel 支付渠道
     * @param payOrderSn 订单号
     */
    Object pay(@RequestParam String payChannel, @RequestParam String payOrderSn) throws Exception;

    /**
     * 查询支付状态
     *
     * @param payOrderSn 订单号
     * @return 支付状态
     */
    PayOrderStatusDto orderStatus(@RequestParam String payOrderSn) throws Exception;

}
