package cn.com.yict.framemax.frame.service;

import cn.com.yict.framemax.core.service.BaseService;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.frame.model.FmxFileModel;

import java.util.List;

/**
 * @author Focan Zhong
 * @create 2021/9/6
 */
public interface MobileUpdateService extends BaseService {

    /**
     * 保存移动端更新文件
     *
     * @param fileModel
     * @return
     * @throws Exception
     */
    FmxFileModel saveMobilePackage(FmxFileModel fileModel) throws Exception;

    /**
     * 校验移动端是否需要更新
     *
     * @param appName
     * @param versison
     * @param platform
     * @return
     * @throws Exception
     */
    FmxFileModel checkMobilePackage(String appName, String versison, String platform) throws Exception;


    /**
     * 移动端版本记录
     *
     * @param fileModel
     * @return
     * @throws Exception
     */
    List<FmxFileModel> mobilePackageList(FmxFileModel fileModel, PagingInfo pagingInfo) throws Exception;
}
