package cn.com.poc.equity.aggregate;

import cn.com.poc.equity.constants.EquityEnum;
import cn.com.poc.equity.constants.ModifyEventEnum;
import cn.com.poc.equity.domain.modifyEquityInfo.AgentUseModifyEventInfo;
import cn.com.poc.equity.domain.modifyEquityInfo.PayModifyEventInfo;
import cn.com.poc.equity.service.BizPaymentPackageConfigurationService;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author alex.yao
 * @date 2024/12/6
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class MemberEquityServiceTest {

    @Resource
    @InjectMocks
    private MemberEquityService memberEquityService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    @Rollback
    @Transactional
    public void testInitMemberEquity() throws Exception {
        memberEquityService.initMemberEquity(197L);
    }

    @Test
    public void testAddPoint() throws Exception {
        PayModifyEventInfo modifyEventInfo = new PayModifyEventInfo();
        modifyEventInfo.setPayOrderSn("PS1733390269000933");
        memberEquityService.addPoint(197L, 1000L, EquityEnum.VALIDITY_UNIT.year, ModifyEventEnum.top_up, modifyEventInfo);
    }

    @Test
    public void testReducePoint() throws Exception {
        AgentUseModifyEventInfo modifyEventInfo = new AgentUseModifyEventInfo();
        modifyEventInfo.setAgentId("fd193bb67d5c42abbbef165a913d47f6");
        memberEquityService.reducePoint(197L, 1L, ModifyEventEnum.use, modifyEventInfo);
    }

    @Test
    public void rollbackPoint() throws Exception {
        memberEquityService.rollbackPoint("PO1733480173765652");
    }

    @Test
    public void changeEquityLevel() throws Exception {
        PayModifyEventInfo modifyEventInfo = new PayModifyEventInfo();
        modifyEventInfo.setPayOrderSn("PS1733382251673130");
        memberEquityService.changeEquityLevel(197L, ModifyEventEnum.top_up, EquityEnum.TYPE.professional,
                EquityEnum.VALIDITY_UNIT.year, modifyEventInfo);
        memberEquityService.addPoint(197L, 1500L, EquityEnum.VALIDITY_UNIT.year, ModifyEventEnum.top_up, modifyEventInfo);
    }
}
