package cn.com.poc.equity.rest;


import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.equity.dto.EquityPackagesDto;
import cn.com.poc.equity.rest.EquityRest;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;

import static org.junit.Assert.assertNotNull;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class EquityRestTest {

    @Resource
    @InjectMocks
    EquityRest equityRest;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void test_getPackageList() {
        EquityPackagesDto packageList = equityRest.getPackageList();
        assertNotNull(packageList);
        System.out.println(JsonUtils.serialize(packageList));
    }

    @Test
    public void test_getPointPackageList() {
        Object result = equityRest.getPointPackageList();
        assertNotNull(result);
        System.out.println(JsonUtils.serialize(result));
    }

}
