package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.thirdparty.resource.demand.ai.function.document_reader.DocumentReaderFunction;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

import static org.junit.Assert.assertNotNull;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class DocumentReaderFunctionTest {

    @Resource
    @InjectMocks
    DocumentReaderFunction documentReaderFunction;

    @Before
    public void init() {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void testDoFunction() {
        String content = "{\"file_urls\": [\"https://gsst-poe-sit.gz.bcebos.com/data/20241127/1732704249980.docx\"]}";
        String identifier = UUID.randomUUID().toString();
        String RESULT = documentReaderFunction.doFunction(content, identifier);
        assertNotNull(RESULT);
    }

    @Test
    public void testGetDesc() {
        System.out.println(documentReaderFunction.getDesc());
    }

    @Test
    public void testGetLLMConfig() {
        System.out.println(documentReaderFunction.getLLMConfig());
    }

    @Test
    public void testGetLLMConfigToVariableStructure() {
        List<Variable> variableStructure = Mockito.mock(List.class);
        System.out.println(documentReaderFunction.getLLMConfig(variableStructure));
    }
}
