package cn.com.poc.timbre.service;


import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.List;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class BizVoiceTimbreServiceTest {

    @Resource
    private BizVoiceTimbreService bizVoiceTimbreService;


    @Test
    public void getByTimbreIdTest() {
        BizVoiceTimbreEntity bizVoiceTimbreEntity = bizVoiceTimbreService.getByTimbreId("101019");
        System.out.println(JsonUtils.serialize(bizVoiceTimbreEntity));
        // 获取不存在
        System.out.println(JsonUtils.serialize(bizVoiceTimbreService.getByTimbreId("1")));
    }


    @Test
    public void findByExampleTest() throws Exception {
        BizVoiceTimbreEntity bizVoiceTimbreEntity = new BizVoiceTimbreEntity();
        bizVoiceTimbreEntity.setIsDeleted(CommonConstant.YOrN.N);
        List<BizVoiceTimbreEntity> entities = bizVoiceTimbreService.findByExample(bizVoiceTimbreEntity, new PagingInfo(10, 1));
        System.out.println(JsonUtils.listToJson(entities));
    }

}
