package cn.com.poc.user.builder;


import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.config.Config;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class LoginChannelTest {

    @Autowired
    @InjectMocks
    EmailLoginChannel emailLoginChannel;

    @Autowired
    @InjectMocks
    SmsLoginChannel smsLoginChannel;

    @Mock
    JudgeCodeService judgeCodeService;

    @Before
    public void setup() {
        // 启用 Mockito 注解
        MockitoAnnotations.initMocks(this);
    }

    @Test(expected = I18nMessageException.class)
    @Transactional
    @Rollback
    public void testEmailDoLogin_judgeCodeError() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(false);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        emailLoginChannel.doLogin(memberLoginRequest);
    }


    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao1@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787613");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787614");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

    @Test
    public void testGoogleLogin_idTokenVerify() throws GeneralSecurityException, IOException {
        String idTokenString = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImFiODYxNGZmNjI4OTNiYWRjZTVhYTc5YTc3MDNiNTk2NjY1ZDI0NzgiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhenAiOiI2OTg3NzQ5NTc0NjEtYjNzMWw5OG03cWp2NWlscGh2bG81N2dqaGJzN2ZuZm0uYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJhdWQiOiI2OTg3NzQ5NTc0NjEtYjNzMWw5OG03cWp2NWlscGh2bG81N2dqaGJzN2ZuZm0uYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJzdWIiOiIxMTY0NTU4OTc5OTYyNzQ1NDk4MjEiLCJlbWFpbCI6InRlcnJ5bGFud0BnbWFpbC5jb20iLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwibmJmIjoxNzM1Mjc5OTM3LCJuYW1lIjoidGVycnkgbGFuIiwicGljdHVyZSI6Imh0dHBzOi8vbGgzLmdvb2dsZXVzZXJjb250ZW50LmNvbS9hL0FDZzhvY0p2azFpOEFYZkJza3Q5d3JzamJNdVZDOHhqWlJ3NXVFWlE5elFveXJRWVFZUUJaQT1zOTYtYyIsImdpdmVuX25hbWUiOiJ0ZXJyeSIsImZhbWlseV9uYW1lIjoibGFuIiwiaWF0IjoxNzM1MjgwMjM3LCJleHAiOjE3MzUyODM4MzcsImp0aSI6IjlkZDAyYTJmNzc2ZjA0NjkxYmFkY2JiZDg5ZDRmNThiZmMxZWM3NzcifQ.ccc5cHGceXaqOmt6l3itLHmysA2SDoNWQ-s-fUs6fLnViToxyheyayuIzVSntfxtplRcrTuTXNnKrGp_EjIHUT0RKb4NyaDNpCeIXYXOjJaphArkUXNDUPodDxbPuCWZZ5D2b1cm2IzTtw-44Z4bj7PBN-5q00cEtXujlAb4QidAnOyOMibY2R7nU1P5qs7jL2zgdoyn1jG4Xoo2kg12uxeX0IhWp0Y_WwBPMpndtmg-NZm-Av1rVNEeR_82nTWsGBVKdtwwycVCMoK4p0D_J7KNGqz_dXwGxCwde0rIDp5XuJYhorp6dQUFirG0-sE9wcoiTiYuxvaf_3OkT0V9ew";
        String CLIENT_ID = Config.get("google.client.id");
        HttpTransport transport = new ApacheHttpTransport();
        JsonFactory jsonFactory = new GsonFactory();
        GooglePublicKeysManager.Builder builder = new GooglePublicKeysManager.Builder(transport, jsonFactory);
        builder.setPublicCertsEncodedUrl("https://google-api.gsstcloud.com/oauth2/v1/certs");
        GoogleIdTokenVerifier verifier = new GoogleIdTokenVerifier.Builder(builder.build())
                .setAudience(Collections.singletonList(CLIENT_ID))
                .build();
        GoogleIdToken idToken = verifier.verify(idTokenString);
        System.out.println(idToken);

    }
}
