package cn.com.poc.data_analyze.aggregate.impl;

import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.data_analyze.aggregate.DataAnalyzeReportService;
import cn.com.poc.data_analyze.constants.DataAnalyzeChannelEnum;
import cn.com.poc.data_analyze.constants.DataAnalyzeTypeEnum;
import cn.com.poc.data_analyze.entity.*;
import cn.com.poc.data_analyze.service.BizDataAnalyzeDialogueRecordService;
import cn.com.poc.data_analyze.service.BizDataAnalyzePointRecordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @author alex.yao
 * @date 2024/12/10
 */
@Service
public class DataAnalyzeReportServiceImpl implements DataAnalyzeReportService {

    private final Logger logger = LoggerFactory.getLogger(DataAnalyzeReportService.class);

    @Resource
    private BizDataAnalyzePointRecordService bizDataAnalyzePointRecordService;

    @Resource
    private BizDataAnalyzeDialogueRecordService bizDataAnalyzeDialogueRecordService;

    @Override
    public void dataReportByPoint(Long memberId, BigDecimal point, DataAnalyzeTypeEnum type, String relationId, DataAnalyzeChannelEnum channel) {
        try {
            BizDataAnalyzePointRecordEntity entity = new BizDataAnalyzePointRecordEntity();
            entity.setRelationId(relationId);
            entity.setType(type.getType());
            entity.setMemberId(memberId);
            entity.setPointNum(point.setScale(2).doubleValue());
            entity.setChannel(channel.getChannel());
            entity.setDatetime(DateUtils.getCurrDateTime());
            bizDataAnalyzePointRecordService.save(entity);
        } catch (Exception e) {
            logger.error("积分使用情况-数据统计异常", e);
        }
    }

    @Override
    public void dataReportByDialogue(Long memberId, DataAnalyzeTypeEnum type, String relationId, DataAnalyzeChannelEnum channel) {
        try {
            BizDataAnalyzeDialogueRecordEntity bizDataAnalyzeDialogueRecordEntity = new BizDataAnalyzeDialogueRecordEntity();
            bizDataAnalyzeDialogueRecordEntity.setRelationId(relationId);
            bizDataAnalyzeDialogueRecordEntity.setType(type.getType());
            bizDataAnalyzeDialogueRecordEntity.setMemberId(memberId);
            bizDataAnalyzeDialogueRecordEntity.setChannel(channel.getChannel());
            bizDataAnalyzeDialogueRecordEntity.setDatetime(DateUtils.getCurrDateTime());
            bizDataAnalyzeDialogueRecordService.save(bizDataAnalyzeDialogueRecordEntity);
        } catch (Exception e) {
            logger.error("对话次数统计情况-数据统计异常", e);
        }
    }
}
