package cn.com.poc.equity.aggregate.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.equity.aggregate.PointDeductionRulesService;
import cn.com.poc.equity.constants.RuleType;
import cn.com.poc.equity.entity.BizPointDeductionRulesEntity;
import cn.com.poc.equity.service.BizPointDeductionRulesService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Tool;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author alex.yao
 * @date 2024/12/9
 */
@Service
public class PointDeductionRulesServiceImpl implements PointDeductionRulesService {

    @Resource
    private BizPointDeductionRulesService bizPointDeductionRulesService;

    @Override
    public Long calculatePointDeductionNum(String modelName, Integer communicationTurn, List<Tool> tools) {
        Long pointDeductionNum = 0L;
        BizPointDeductionRulesEntity bizPointDeductionRulesEntity = new BizPointDeductionRulesEntity();
        bizPointDeductionRulesEntity.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizPointDeductionRulesEntity> entities = bizPointDeductionRulesService.findByExample(bizPointDeductionRulesEntity, null);
        Map<String, List<BizPointDeductionRulesEntity>> map = entities.stream().collect(Collectors.groupingBy(BizPointDeductionRulesEntity::getRuleType, Collectors.toList()));
        // 模型扣分
        if (StringUtils.isNotBlank(modelName) && map.containsKey(RuleType.MODEL.getRuleType())) {
            List<BizPointDeductionRulesEntity> modelDeductionRules = map.get(RuleType.MODEL.getRuleType());
            for (BizPointDeductionRulesEntity modelDeductionRule : modelDeductionRules) {
                if (modelDeductionRule.getRelationId().equals(modelName)) {
                    pointDeductionNum = pointDeductionNum + modelDeductionRule.getNumber();
                    break;
                }
            }
        }
        //轮次 1-5-10-15   1轮和5轮扣模型原始的积分   10轮 原始积分*2  15轮 原始积分*3
        if (communicationTurn != null && map.containsKey(RuleType.COMMUNICATION_TURN.getRuleType())) {
            List<BizPointDeductionRulesEntity> communicationTurnRules = map.get(RuleType.COMMUNICATION_TURN.getRuleType());
            for (BizPointDeductionRulesEntity communicationTurnRule : communicationTurnRules) {
                if (communicationTurnRule.getRelationId().equals(String.valueOf(communicationTurn))) {
                    pointDeductionNum = pointDeductionNum * communicationTurnRule.getNumber() + pointDeductionNum;
                    break;
                }
            }
        }
        // 插件扣分
        if (CollectionUtils.isNotEmpty(tools) && map.containsKey(RuleType.PLUGIN.getRuleType())) {
            List<BizPointDeductionRulesEntity> pluginRules = map.get(RuleType.PLUGIN.getRuleType());
            for (Tool tool : tools) {
                for (BizPointDeductionRulesEntity pluginRule : pluginRules) {
                    if (pluginRule.getRelationId().equals(tool.getFunction().getName())) {
                        pointDeductionNum = pointDeductionNum + pluginRule.getNumber();
                        break;
                    }
                }
            }
        }
        return pointDeductionNum;
    }
}
