package cn.com.poc.equity.rest;

import cn.com.poc.equity.dto.CurrentUserPayOrderDto;
import cn.com.poc.equity.dto.EquityOrderCreateDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Permission(Access.Safety)
public interface EquityOrderRest extends BaseRest {

    /**
     * 创建权益订单
     *
     * @return 订单号
     */
    @Deprecated
    String createOrder(@RequestBody EquityOrderCreateDto createDto) throws Exception;


    /**
     * 获取用户套餐充值列表(已支付，已发放)
     *
     * @return
     */
    List<CurrentUserPayOrderDto> getCurrentUserPayOrderList(@RequestParam String domain, PagingInfo pagingInfo);

}
