package cn.com.poc.expose.aggregate.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.data_analyze.constants.DataAnalyzeTimeDimensionEnum;
import cn.com.poc.data_analyze.constants.DataAnalyzeTimeRangeEnum;
import cn.com.poc.data_analyze.domain.ChannelDataCount;
import cn.com.poc.data_analyze.domain.DataAnalyze;
import cn.com.poc.data_analyze.domain.DataAnalyzeInfo;
import cn.com.poc.data_analyze.domain.DataAnalyzeTimeRange;
import cn.com.poc.data_analyze.entity.*;
import cn.com.poc.data_analyze.query.*;
import cn.com.poc.data_analyze.service.BizDataAnalyzeDialogueRecordService;
import cn.com.poc.data_analyze.service.BizDataAnalyzePointRecordService;
import cn.com.poc.expose.aggregate.AgentDataAnalyzeService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/11
 */
@Service
public class AgentDataAnalyzeServiceImpl implements AgentDataAnalyzeService {
    @Resource
    private BizDataAnalyzePointRecordService bizDataAnalyzePointRecordService;

    @Resource
    private BizDataAnalyzeDialogueRecordService bizDataAnalyzeDialogueRecordService;


    @Override
    public List<AgentDataAnalyzeGeneralEntity> getGeneralUsageData(String agentId, List<String> channel) {
        List<AgentDataAnalyzeGeneralEntity> result = new ArrayList<>();
        // 积分使用情况
        PointsUsageQueryCondition condition = new PointsUsageQueryCondition();
        condition.setRelationId(agentId);
        condition.setChannels(channel);
        List<PointsUsageQueryItem> pointsUsageQueryItems = bizDataAnalyzePointRecordService.pointsUsageQuery(condition, null);

        // 对话情况
        AgentUsageQueryCondition agentUsageQueryCondition = new AgentUsageQueryCondition();
        agentUsageQueryCondition.setChannels(channel);
        agentUsageQueryCondition.setRelationId(agentId);
        List<AgentUsageQueryItem> agentUsageQueryItems = bizDataAnalyzeDialogueRecordService.agentUsageQuery(agentUsageQueryCondition, null);

        // 1.获取今日数据
        // 积分
        DataAnalyzeInfo todayDataAnlalyzeInfo = new DataAnalyzeInfo();
        DataAnalyze todayPointsCount = new DataAnalyze();
        setPointsDataAnalyze(pointsUsageQueryItems, todayPointsCount);
        todayDataAnlalyzeInfo.setPointsCount(todayPointsCount);
        //使用人数
        DataAnalyze todayUsersCount = new DataAnalyze();
        setUserCountDataAnalyze(todayUsersCount, agentUsageQueryItems);
        todayDataAnlalyzeInfo.setUsersCount(todayUsersCount);
        //使用量
        DataAnalyze todayUsageCount = new DataAnalyze();
        setUsageDataAnalyze(todayUsageCount, agentUsageQueryItems);
        todayDataAnlalyzeInfo.setUsageCount(todayUsageCount);

        AgentDataAnalyzeGeneralEntity today = new AgentDataAnalyzeGeneralEntity();
        today.setTimeDimension(DataAnalyzeTimeDimensionEnum.today.name());
        today.setDataAnalyzeInfo(todayDataAnlalyzeInfo);
        result.add(today);


        //2. 获取本周数据
        DataAnalyzeInfo weekDataAnalyzeInfo = new DataAnalyzeInfo();
        //积分
        DataAnalyze weekPointsCount = new DataAnalyze();
        setPointsDataAnalyze(pointsUsageQueryItems, weekPointsCount);
        weekDataAnalyzeInfo.setPointsCount(weekPointsCount);
        //使用人数
        DataAnalyze weekUsersCount = new DataAnalyze();
        setUserCountDataAnalyze(weekUsersCount, agentUsageQueryItems);
        weekDataAnalyzeInfo.setUsersCount(weekUsersCount);
        //使用量
        DataAnalyze weekUsageCount = new DataAnalyze();
        setUsageDataAnalyze(weekUsageCount, agentUsageQueryItems);
        weekDataAnalyzeInfo.setUsageCount(weekUsageCount);

        AgentDataAnalyzeGeneralEntity week = new AgentDataAnalyzeGeneralEntity();
        week.setTimeDimension(DataAnalyzeTimeDimensionEnum.week.name());
        week.setDataAnalyzeInfo(weekDataAnalyzeInfo);
        result.add(week);


        //3. 获取本月数据
        DataAnalyzeInfo monthDataAnalyzeInfo = new DataAnalyzeInfo();
        //积分
        DataAnalyze monthPointsCount = new DataAnalyze();
        setPointsDataAnalyze(pointsUsageQueryItems, monthPointsCount);
        monthDataAnalyzeInfo.setPointsCount(monthPointsCount);
        //使用人数
        DataAnalyze monthUsersCount = new DataAnalyze();
        setUserCountDataAnalyze(monthUsersCount, agentUsageQueryItems);
        monthDataAnalyzeInfo.setUsersCount(monthUsersCount);
        //使用量
        DataAnalyze monthUsageCount = new DataAnalyze();
        setUsageDataAnalyze(monthUsageCount, agentUsageQueryItems);
        monthDataAnalyzeInfo.setUsageCount(monthUsageCount);

        AgentDataAnalyzeGeneralEntity month = new AgentDataAnalyzeGeneralEntity();
        month.setTimeDimension(DataAnalyzeTimeDimensionEnum.month.name());
        month.setDataAnalyzeInfo(monthDataAnalyzeInfo);
        result.add(month);
        return result;
    }

    @Override
    public List<ChannelUsersCountEntity> getChannelUserCount(String agentId, List<String> channel) {
        List<ChannelUsersCountEntity> result = new ArrayList<>();
        //1. 获取本周的日期范围
        Date currDateTime = DateUtils.getCurrDateTime();
        //2. 获取本周第二周前的日期范围
        Date secondDateTime = DateUtils.addDays(currDateTime, -7);
        //3. 获取本周第三周前的日期范围
        Date threeDateTime = DateUtils.addDays(secondDateTime, -7);
        //4. 获取本周第四周前的日期范围
        Date fourDateTime = DateUtils.addDays(threeDateTime, -7);

        channelUserConvert(agentId, channel, fourDateTime, result);
        channelUserConvert(agentId, channel, threeDateTime, result);
        channelUserConvert(agentId, channel, secondDateTime, result);
        channelUserConvert(agentId, channel, currDateTime, result);
        return result;
    }

    @Override
    public List<ChannelUsageCountEntity> getSendMessageCount(String agentId, List<String> channel) {
        List<ChannelUsageCountEntity> result = new ArrayList<>();
        ChannelUsageCountQueryCondition condition = new ChannelUsageCountQueryCondition();
        condition.setRelationId(agentId);
        condition.setChannels(channel);
        List<ChannelUsageCountQueryItem> channelUsageCountQueryItems = bizDataAnalyzeDialogueRecordService.channelUsageCountQuery(condition, null);
        for (ChannelUsageCountQueryItem item : channelUsageCountQueryItems) {
            ChannelUsageCountEntity channelUsageCountEntity = new ChannelUsageCountEntity();
            channelUsageCountEntity.setChannel(item.getChannel());
            channelUsageCountEntity.setCount(item.getUsageCount());
            result.add(channelUsageCountEntity);
        }
        return result;
    }

    @Override
    public List<ChannelPointCountEntity> getPointUsageCount(String agentId, List<String> channel) {
        List<ChannelPointCountEntity> result = new ArrayList<>();
        ChannelPointsCountQueryCondition condition = new ChannelPointsCountQueryCondition();
        condition.setChannels(channel);
        condition.setRelationId(agentId);
        List<ChannelPointsCountQueryItem> channelPointsCountQueryItems = bizDataAnalyzePointRecordService.channelPointsCountQuery(condition, null);
        for (ChannelPointsCountQueryItem item : channelPointsCountQueryItems) {
            ChannelPointCountEntity channelPointCountEntity = new ChannelPointCountEntity();
            channelPointCountEntity.setChannel(item.getChannel());
            channelPointCountEntity.setCount(item.getTotalPoints());
            result.add(channelPointCountEntity);
        }
        return result;
    }

    @Override
    public List<AgentDataAnalyzeTrendEntity> getAgentDataTrend(String agentId, List<String> channel, DataAnalyzeTimeRange timeRange) {
        String rangType = timeRange.getRangType();
        String startTime = "";
        String endTime = "";
        if (DataAnalyzeTimeRangeEnum.WEEK.getType().equals(rangType)) {
            Date endDate = DateUtils.getTodayEnd();
            Date startDate = DateUtils.getDayStartTime(DateUtils.addDays(endDate, -6));
            startTime = DateUtils.formatDate(startDate, DateUtils.yyyy_MM_dd);
            endTime = DateUtils.formatDate(endDate, DateUtils.yyyy_MM_dd_HH_mm_ss);
        } else if (DataAnalyzeTimeRangeEnum.MONTH.getType().equals(rangType)) {
            Date endDate = DateUtils.getTodayEnd();
            Date startDate = DateUtils.getDayStartTime(DateUtils.addDays(endDate, -29));
            startTime = DateUtils.formatDate(startDate, DateUtils.yyyy_MM_dd);
            endTime = DateUtils.formatDate(endDate, DateUtils.yyyy_MM_dd_HH_mm_ss);
        } else if (DataAnalyzeTimeRangeEnum.CUSTOMIZE.getType().equals(rangType)) {
            startTime = timeRange.getStartTime();
            Date endDate = DateUtils.getDayEnd(DateUtils.stringToDateShort(timeRange.getEndTime()));
            endTime = DateUtils.formatDate(endDate, DateUtils.yyyy_MM_dd_HH_mm_ss);
        }
        AgentDataTrendQueryCondition agentDataTrendQueryCondition = new AgentDataTrendQueryCondition();
        agentDataTrendQueryCondition.setStartDate(startTime);
        agentDataTrendQueryCondition.setEndDate(endTime);
        agentDataTrendQueryCondition.setRelationId(agentId);
        agentDataTrendQueryCondition.setChannels(channel);
        List<AgentDataAnalyzeTrendEntity> result = new ArrayList<>();
        List<AgentDataTrendQueryItem> agentDataTrendQueryItems = bizDataAnalyzeDialogueRecordService.agentDataTrendQuery(agentDataTrendQueryCondition, null);
        if (CollectionUtils.isNotEmpty(agentDataTrendQueryItems)) {
            for (AgentDataTrendQueryItem item : agentDataTrendQueryItems) {
                AgentDataAnalyzeTrendEntity agentDataAnalyzeTrendEntity = new AgentDataAnalyzeTrendEntity();
                agentDataAnalyzeTrendEntity.setDate(item.getDialogueDate());
                agentDataAnalyzeTrendEntity.setUsersCount(item.getMemberCount());
                agentDataAnalyzeTrendEntity.setUsageCount(item.getUsageCount());
                agentDataAnalyzeTrendEntity.setTotalPoints(item.getTotalPoints());
                result.add(agentDataAnalyzeTrendEntity);
            }
        }
        return result;
    }


    private static void setUsageDataAnalyze(DataAnalyze dataAnalyze, List<AgentUsageQueryItem> agentUsageQueryItems) {
        if (dataAnalyze == null) {
            dataAnalyze = new DataAnalyze();
        }

        if (CollectionUtils.isNotEmpty(agentUsageQueryItems)) {
            dataAnalyze.setNum(agentUsageQueryItems.get(0).getTodayDialogue().doubleValue());
            dataAnalyze.setFluctuate((short) (agentUsageQueryItems.get(0).getTodayDialogue() < agentUsageQueryItems.get(0).getYesterdayDialogue() ? -1 : 1));
        } else {
            dataAnalyze.setNum(0D);
            dataAnalyze.setFluctuate((short) 0);
        }
    }

    private static void setUserCountDataAnalyze(DataAnalyze dataAnalyze, List<AgentUsageQueryItem> agentUsageQueryItems) {
        if (dataAnalyze == null) {
            dataAnalyze = new DataAnalyze();
        }

        if (CollectionUtils.isNotEmpty(agentUsageQueryItems)) {
            dataAnalyze.setNum(agentUsageQueryItems.get(0).getMonthDialogueMember().doubleValue());
            dataAnalyze.setFluctuate((short) (agentUsageQueryItems.get(0).getMonthDialogueMember() < agentUsageQueryItems.get(0).getLastMonthDialogueMember() ? -1 : 1));
        } else {
            dataAnalyze.setNum(0D);
            dataAnalyze.setFluctuate((short) 0);
        }
    }

    private static void setPointsDataAnalyze(List<PointsUsageQueryItem> pointsUsageQueryItems, DataAnalyze dataAnalyze) {
        if (dataAnalyze == null) {
            dataAnalyze = new DataAnalyze();
        }

        if (CollectionUtils.isNotEmpty(pointsUsageQueryItems)) {
            dataAnalyze.setNum(pointsUsageQueryItems.get(0).getTodayTotalPoints());
            dataAnalyze.setFluctuate((short) (pointsUsageQueryItems.get(0).getTodayTotalPoints() < pointsUsageQueryItems.get(0).getYesterdayTotalPoints() ? -1 : 1));
        } else {
            dataAnalyze.setNum(0D);
            dataAnalyze.setFluctuate((short) 0);
        }
    }


    private void channelUserConvert(String agentId, List<String> channel, Date currDateTime, List<ChannelUsersCountEntity> result) {
        Date thisWeekBegin = DateUtils.getWeekBegin2(currDateTime);
        Date thisWeekEnd = DateUtils.getWeekEnd2(currDateTime);
        ChannelUserCountQueryCondition thisWeekCondition = new ChannelUserCountQueryCondition();
        thisWeekCondition.setStartDate(DateUtils.formatDate(thisWeekBegin, DateUtils.yyyy_MM_dd_HH_mm_ss));
        thisWeekCondition.setEndDate(DateUtils.formatDate(thisWeekEnd, DateUtils.yyyy_MM_dd_HH_mm_ss));
        thisWeekCondition.setRelationId(agentId);
        thisWeekCondition.setChannels(channel);
        List<ChannelUserCountQueryItem> thisWeekItems = bizDataAnalyzeDialogueRecordService.channelUserCountQuery(thisWeekCondition, null);

        List<ChannelDataCount> channelDataCountList = new ArrayList<>();
        for (ChannelUserCountQueryItem thisWeekItem : thisWeekItems) {
            ChannelDataCount channelDataCount = new ChannelDataCount();
            channelDataCount.setChannel(thisWeekItem.getChannel());
            channelDataCount.setCount(thisWeekItem.getMemberCount());
            channelDataCountList.add(channelDataCount);
        }

        ChannelUsersCountEntity countEntity = new ChannelUsersCountEntity();
        countEntity.setDate(DateUtils.formatDate(thisWeekBegin, DateUtils.yyyy_MM_dd) + "_" + DateUtils.formatDate(thisWeekEnd, DateUtils.yyyy_MM_dd));
        countEntity.setChannelDataCount(channelDataCountList);
        result.add(countEntity);
    }
}
