package cn.com.poc.expose.rest;

import cn.com.poc.expose.dto.agent_data_analyze.*;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/10
 */
@Permission(Access.Safety)
public interface AgentDataAnalyzeRest extends BaseRest {

    /**
     * 获取应用大体用量数据
     *
     * @param agentId 应用ID
     * @param channel 渠道
     * @return 应用大体用量数据
     */
    List<AgentDataAnalyzeGeneralDto> getGeneralUsageData(@RequestParam String agentId, @RequestParam List<String> channel) throws Exception;

    /**
     * 当月渠道使用人数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     * @@return 当月渠道使用人数占比
     */
    List<ChannelUsersCountDto> getChannelUsersCount(@RequestParam String agentId, @RequestParam List<String> channel);

    /**
     * 获取当月分渠道发送消息数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     */
    List<ChannelUsageCountDto> getSendMessageCount(@RequestParam String agentId, @RequestParam List<String> channel);

    /**
     * 获取当月分渠道积分消耗数占比
     *
     * @param agentId 应用ID
     * @param channel 渠道
     */
    List<ChannelPointCountDto> getPointUsageCount(@RequestParam String agentId, @RequestParam List<String> channel);

    /**
     * 获取Agent应用数据趋势图
     *
     * @param dto 请求参数
     */
    List<AgentDataAnalyzeTrendDto> getAgentDataTrend(@RequestBody GetAgentDataTrendRequestDto dto);
}
