package cn.com.poc.expose.rest.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.data_analyze.entity.*;
import cn.com.poc.expose.aggregate.AgentDataAnalyzeService;
import cn.com.poc.expose.dto.agent_data_analyze.*;
import cn.com.poc.expose.rest.AgentDataAnalyzeRest;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author alex.yao
 * @date 2024/12/10
 */
@Component
public class AgentDataAnalyzeRestImpl implements AgentDataAnalyzeRest {

    @Resource
    private AgentDataAnalyzeService agentDataAnalyzeService;

    @Resource
    private AgentApplicationInfoService agentApplicationInfoService;

    @Override
    public List<AgentDataAnalyzeGeneralDto> getGeneralUsageData(String agentId, List<String> channel) {
        checkPermission(agentId);
        List<AgentDataAnalyzeGeneralDto> result = new ArrayList<>();
        List<AgentDataAnalyzeGeneralEntity> generalUsageDataEntity = agentDataAnalyzeService.getGeneralUsageData(agentId, channel);
        for (AgentDataAnalyzeGeneralEntity entity : generalUsageDataEntity) {
            AgentDataAnalyzeGeneralDto agentDataAnalyzeGeneralDto = new AgentDataAnalyzeGeneralDto();
            agentDataAnalyzeGeneralDto.setTimeDimension(entity.getTimeDimension());
            agentDataAnalyzeGeneralDto.setDataAnalyzeInfo(entity.getDataAnalyzeInfo());
            result.add(agentDataAnalyzeGeneralDto);
        }
        return result;
    }


    @Override
    public List<ChannelUsersCountDto> getChannelUsersCount(String agentId, List<String> channel) {
        checkPermission(agentId);
        List<ChannelUsersCountDto> result = new ArrayList<>();
        List<ChannelUsersCountEntity> channelUsersCountEntities = agentDataAnalyzeService.getChannelUserCount(agentId, channel);
        for (ChannelUsersCountEntity entity : channelUsersCountEntities) {
            ChannelUsersCountDto channelUsersCountDto = new ChannelUsersCountDto();
            channelUsersCountDto.setDate(entity.getDate());
            channelUsersCountDto.setChannelDataCount(entity.getChannelDataCount());
            result.add(channelUsersCountDto);
        }
        return result;
    }

    @Override
    public List<ChannelUsageCountDto> getSendMessageCount(String agentId, List<String> channel) {
        checkPermission(agentId);
        List<ChannelUsageCountDto> result = new ArrayList<>();
        List<ChannelUsageCountEntity> sendMessageCountEntities = agentDataAnalyzeService.getSendMessageCount(agentId, channel);
        for (ChannelUsageCountEntity entity : sendMessageCountEntities) {
            ChannelUsageCountDto channelUsageCountDto = new ChannelUsageCountDto();
            channelUsageCountDto.setChannel(entity.getChannel());
            channelUsageCountDto.setCount(entity.getCount());
            result.add(channelUsageCountDto);
        }
        return result;
    }

    @Override
    public List<ChannelPointCountDto> getPointUsageCount(String agentId, List<String> channel) {
        checkPermission(agentId);
        List<ChannelPointCountDto> result = new ArrayList<>();
        List<ChannelPointCountEntity> pointCountEntities = agentDataAnalyzeService.getPointUsageCount(agentId, channel);
        for (ChannelPointCountEntity pointCountEntity : pointCountEntities) {
            ChannelPointCountDto channelPointCountDto = new ChannelPointCountDto();
            channelPointCountDto.setChannel(pointCountEntity.getChannel());
            channelPointCountDto.setCount(pointCountEntity.getCount());
            result.add(channelPointCountDto);
        }
        return result;
    }

    @Override
    public List<AgentDataAnalyzeTrendDto> getAgentDataTrend(GetAgentDataTrendRequestDto dto) {
        checkPermission(dto.getAgentId());
        List<AgentDataAnalyzeTrendDto> result = new ArrayList<>();
        List<AgentDataAnalyzeTrendEntity> agentDataAnalyzeTrendEntities = agentDataAnalyzeService.getAgentDataTrend(dto.getAgentId(), dto.getChannel(), dto.getTimeRange());
        for (AgentDataAnalyzeTrendEntity entity : agentDataAnalyzeTrendEntities) {
            AgentDataAnalyzeTrendDto agentDataAnalyzeTrendDto = new AgentDataAnalyzeTrendDto();
            agentDataAnalyzeTrendDto.setDate(entity.getDate());
            agentDataAnalyzeTrendDto.setUsersCount(entity.getUsersCount());
            agentDataAnalyzeTrendDto.setUsageCount(entity.getUsageCount());
            agentDataAnalyzeTrendDto.setTotalPoints(entity.getTotalPoints());
            result.add(agentDataAnalyzeTrendDto);
        }
        return result;
    }


    private void checkPermission(String agentId) {
        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new I18nMessageException("exception/user.does.not.exist");
        }
        if (!agentApplicationInfoService.hasPublishAgentPermission(agentId, userBaseEntity.getUserId())) {
            throw new I18nMessageException("exception/no.permission");
        }
    }
}
