package cn.com.poc.user.builder;


import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class LoginChannelTest {

    @Autowired
    @InjectMocks
    EmailLoginChannel emailLoginChannel;

    @Autowired
    @InjectMocks
    SmsLoginChannel smsLoginChannel;

    @Mock
    JudgeCodeService judgeCodeService;

    @Before
    public void setup() {
        // 启用 Mockito 注解
        MockitoAnnotations.initMocks(this);
    }

    @Test(expected = I18nMessageException.class)
    @Transactional
    @Rollback
    public void testEmailDoLogin_judgeCodeError() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(false);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        emailLoginChannel.doLogin(memberLoginRequest);
    }


    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testEmailDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("alex.yao1@superlinksoft.com");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) emailLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787613");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
        assertEquals(memberInfoEntity.getMemberId(), Integer.valueOf(197));
    }

    @Test
    @Transactional
    @Rollback
    public void testSmsDoLogin_registerNewAccount() throws Exception {
        when(judgeCodeService.judgeCode(any(), any())).thenReturn(true);
        MemberLoginRequestDto memberLoginRequest = Mockito.mock(MemberLoginRequestDto.class);
        when(memberLoginRequest.getAccount()).thenReturn("13602787614");
        when(memberLoginRequest.getAuthCode()).thenReturn("111");
        MemberInfoEntity memberInfoEntity = (MemberInfoEntity) smsLoginChannel.doLogin(memberLoginRequest);
        assertNotNull(memberInfoEntity);
    }

}
