package cn.com.poc.agent_application.aggregate;

import cn.com.poc.agent_application.entity.BizAgentApplicationInfoEntity;
import cn.com.poc.agent_application.entity.CreateAgentTitleAndDescEntity;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.Message;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.Tool;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface AgentApplicationInfoService {

    /**
     * 更新并发布应用
     */
    boolean updateAndPublish(BizAgentApplicationInfoEntity entity) throws Exception;

    /**
     * 应用预览
     */
    String callAgentApplication(String identifier, String largeModel, String[] unitIds, String agentSystem,
                                Integer[] knowledgeIds, Integer communicationTurn, Float topP,
                                List<Message> messages, List<Tool> tools, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 应用下架
     *
     * @param agentId
     * @return
     */
    boolean unPublish(String agentId) throws Exception;


    /**
     * 角色指令AI生成
     *
     * @param input
     * @param httpServletResponse
     * @return
     */
    void createAgentSystem(String input, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 开场白AI生成
     *
     * @param agentTitle  应用标题
     * @param agentDesc   应用描述
     * @param agentSystem 应用角色指令
     * @return
     */
    String createPreamble(String agentTitle, String agentDesc, String agentSystem);


    /**
     * 推荐问题AI生成
     *
     * @param agentTitle
     * @param agentDesc
     * @return
     * @throws Exception
     */
    List<String> createFeaturedQuestions(String agentTitle, String agentDesc);

    /**
     * AGENT 应用图标生成
     *
     * @param agentTitle 应用标题
     * @param agentDesc  应用描述
     * @return Agent 应用图标URL
     */
    String createAgentIcon(String agentTitle, String agentDesc) throws Exception;

    /**
     * Agent 应用标题，描述生成
     *
     * @param input 用户输入内容
     */
    CreateAgentTitleAndDescEntity createAgentTitleAndDesc(String input);
}
