package cn.com.poc.agent_application.rest;

import cn.com.poc.agent_application.dto.*;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;

import java.util.List;

import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;

@Permission(value = Access.Safety)
public interface AgentApplicationInfoRest extends BaseRest {

    /**
     * 获取应用详情
     */
    AgentApplicationInfoDto getInfo(@RequestParam String agentId) throws Exception;

    /**
     * 获取用户创建应用列表
     */
    List<AgentApplicationInfoDto> getListByMember(@RequestBody AgentApplicationInfoSearchDto dto, PagingInfo pagingInfo) throws Exception;

    /**
     * 创建应用
     */
    AgentApplicationInfoDto saveOrUpdate(@RequestBody AgentApplicationInfoDto dto) throws Exception;

    /**
     * 更新应用
     */
    AgentApplicationInfoDto update(@RequestBody AgentApplicationInfoDto dto) throws Exception;

    /**
     * 删除应用
     */
    void delete(@RequestParam String agentId) throws Exception;

    /**
     * 更新并发布应用
     */
    boolean updateAndPublish(@RequestBody AgentApplicationInfoDto dto) throws Exception;

    /**
     * 应用预览
     */
    void preview(@RequestBody AgentApplicationPreviewDto dto, HttpServletResponse response) throws Exception;

    /**
     * 获取应用模型列表
     */
    List<BizAgentApplicationLargeModelListDto> getLargeModelList() throws Exception;

    /**
     * 查询模型信息
     */
    BizAgentApplicationLargeModelListDto getLargeModelInfo(@RequestParam String query) throws Exception;


    /**
     * 角色指令AI生成
     */
    void createAgentSystem(@RequestBody AgentApplicationGCDto dto, HttpServletResponse response) throws Exception;

    /**
     * [推荐问]生成
     */
    List<String> createFeaturedQuestions(@RequestBody AgentApplicationGCDto dto) throws Exception;

    /**
     * 开场白AI生成
     */
    String createPreamble(@RequestBody AgentApplicationGCDto dto) throws Exception;

    /**
     * AI创建应用头像
     */
    String createAgentApplicationAvatar(@RequestBody AgentApplicationGCDto dto) throws Exception;

    /**
     * AI创建应用标题和描述
     */
    AgentApplicationGCDto createAgentTitleAndDesc(@RequestBody AgentApplicationGCDto dto) throws Exception;
}