package cn.com.poc.agent_application.service.impl;

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.agent_application.service.BizAgentApplicationGcConfigService;
import cn.com.poc.agent_application.model.BizAgentApplicationGcConfigModel;
import cn.com.poc.agent_application.entity.BizAgentApplicationGcConfigEntity;
import cn.com.poc.agent_application.convert.BizAgentApplicationGcConfigConvert;
import cn.com.poc.agent_application.repository.BizAgentApplicationGcConfigRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizAgentApplicationGcConfigServiceImpl extends BaseServiceImpl
        implements BizAgentApplicationGcConfigService {

    @Resource
    private BizAgentApplicationGcConfigRepository repository;

    @Override
    public BizAgentApplicationGcConfigEntity getByConfigCode(String configCode) {
        Assert.notNull(configCode);
        BizAgentApplicationGcConfigModel model = new BizAgentApplicationGcConfigModel();
        model.setConfigCode(configCode);
        List<BizAgentApplicationGcConfigModel> models = this.repository.findByExample(model);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizAgentApplicationGcConfigConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public BizAgentApplicationGcConfigEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationGcConfigModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        return BizAgentApplicationGcConfigConvert.modelToEntity(model);
    }


    public List<BizAgentApplicationGcConfigEntity> findByExample(BizAgentApplicationGcConfigEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizAgentApplicationGcConfigEntity> result = new ArrayList<BizAgentApplicationGcConfigEntity>();
        BizAgentApplicationGcConfigModel model = new BizAgentApplicationGcConfigModel();
        if (example != null) {
            model = BizAgentApplicationGcConfigConvert.entityToModel(example);
        }
        List<BizAgentApplicationGcConfigModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizAgentApplicationGcConfigConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizAgentApplicationGcConfigEntity save(BizAgentApplicationGcConfigEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        BizAgentApplicationGcConfigModel model = BizAgentApplicationGcConfigConvert.entityToModel(entity);
        BizAgentApplicationGcConfigModel saveModel = this.repository.save(model);
        return BizAgentApplicationGcConfigConvert.modelToEntity(saveModel);
    }

    public BizAgentApplicationGcConfigEntity update(BizAgentApplicationGcConfigEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizAgentApplicationGcConfigModel model = this.repository.get(entity.getId());

        if (entity.getConfigCode() != null) {
            model.setConfigCode(entity.getConfigCode());
        }
        if (entity.getConfigSystem() != null) {
            model.setConfigSystem(entity.getConfigSystem());
        }
        if (entity.getLargeModel() != null) {
            model.setLargeModel(entity.getLargeModel());
        }
        if (entity.getTopP() != null) {
            model.setTopP(entity.getTopP());
        }
        BizAgentApplicationGcConfigModel saveModel = this.repository.save(model);
        return BizAgentApplicationGcConfigConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizAgentApplicationGcConfigModel model = this.repository.get(id);
        if (model != null) {
        }
    }

}