package cn.com.poc.common.rest.impl;

import cn.com.poc.common.rest.BosRest;
import cn.com.poc.common.service.BosConfigService;
import cn.com.poc.common.utils.Assert;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;

@Component
public class BosRestImpl implements BosRest {

    @Resource
    private BosConfigService bosConfigService;

    @Override
    public String upload(MultipartFile file) throws IOException {
        Assert.notNull(file, "文件不能为空");
        String contentType = file.getContentType();
        String originalFilename = file.getOriginalFilename();
        String prefix = originalFilename.substring(originalFilename.lastIndexOf(".")).replaceAll("\\.", "");
        return bosConfigService.upload(file.getInputStream(), prefix, contentType);
    }
}
