package cn.com.poc.common.rest.impl;

import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.rest.JudgeCodeRest;
import cn.com.yict.framemax.core.exception.BusinessException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class JudgeCodeRestImpl implements JudgeCodeRest {

        @Resource
        private JudgeCodeService judgeCodeService;

        @Override
        public boolean judgeCode(String account, String code) throws BusinessException {
            Assert.notBlank(account, "用户登录，登录账号不能为空");
            Assert.notBlank(code, "验证码不能为空");
            return judgeCodeService.judgeCode(account, code);
        }

        @Override
        public String judgeCodeReturnAuthCode(String account, String code) throws BusinessException {
            Assert.notBlank(account, "用户登录，登录账号不能为空");
            Assert.notBlank(code, "验证码不能为空");
            return judgeCodeService.judgeCodeReturnAuthCode(account, code);
        }
}
