package cn.com.poc.common.rest.impl;

import cn.com.poc.common.rest.SendEmailRest;
import cn.com.poc.common.service.SendEmailService;
import cn.com.poc.common.utils.Assert;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class SendEmailRestImpl implements SendEmailRest {

    @Resource
    private SendEmailService sendEmailService;

    @Override
    public void sendEmailCode(String emailAddress) throws Exception {
        Assert.notBlank(emailAddress, "用户登录，登录账号不能为空");
        sendEmailService.sendEmailCode(emailAddress);
    }
}
