package cn.com.poc.expose.aggregate.impl;

import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.agent_application.constant.AgentApplicationDialoguesRecordConstants;
import cn.com.poc.agent_application.constant.AgentApplicationGCConfigConstants;
import cn.com.poc.agent_application.entity.BizAgentApplicationDialoguesRecordEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationGcConfigEntity;
import cn.com.poc.agent_application.entity.BizAgentApplicationPublishEntity;
import cn.com.poc.agent_application.service.BizAgentApplicationDialoguesRecordService;
import cn.com.poc.agent_application.service.BizAgentApplicationGcConfigService;
import cn.com.poc.agent_application.service.BizAgentApplicationPublishService;
import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.expose.aggregate.AgentApplicationService;
import cn.com.poc.knowledge.aggregate.KnowledgeService;
import cn.com.poc.support.security.oauth.entity.UserBaseEntity;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.Message;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.MultiContent;
import cn.com.poc.thirdparty.resource.demand.ai.common.domain.Tool;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelDemandResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.largemodel.LargeModelResponse;
import cn.com.poc.thirdparty.resource.demand.ai.function.LargeModelFunctionEnum;
import cn.com.poc.thirdparty.service.LLMService;
import cn.com.yict.framemax.core.exception.BusinessException;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

@Service
public class AgentApplicationServiceImpl implements AgentApplicationService {

    final private Logger logger = LoggerFactory.getLogger(AgentApplicationService.class);

    @Resource
    private KnowledgeService knowledgeService;

    @Resource
    private BizAgentApplicationPublishService bizAgentApplicationPublishService;

    @Resource
    private BizAgentApplicationDialoguesRecordService bizAgentApplicationDialoguesRecordService;

    @Resource
    private AgentApplicationInfoService agentApplicationInfoService;

    @Resource
    private BizAgentApplicationGcConfigService bizAgentApplicationGcConfigService;

    @Resource
    private LLMService llmService;


    @Override
    public void callAgentApplication(String agentId, String dialogsId, String input, HttpServletResponse httpServletResponse) throws Exception {

        UserBaseEntity userBaseEntity = BlContext.getCurrentUserNotException();
        if (userBaseEntity == null) {
            throw new BusinessException("用户未登录");
        }

        // 记录输入时间戳
        Long inputTimestamp = System.currentTimeMillis();

        BizAgentApplicationPublishEntity infoEntity = bizAgentApplicationPublishService.getByAgentId(agentId);
        if (infoEntity == null) {
            logger.warn("can not find agent application , agent_id:{}", agentId);
            throw new BusinessException("未找到应用");
        }

        //获取知识库配置
        List<Integer> kdIdList = knowledgeService.getKdIdsByKnowledgeInfoIds(infoEntity.getKnowledgeIds());

        // 构造对话参数
        List<Message> messages = new ArrayList<>();
        buildMessages(dialogsId, agentId, userBaseEntity.getUserId(), messages, input);

        //配置对话function
        List<Tool> tools = new ArrayList<>();
        //开启对话变量
        if (ArrayUtils.isNotEmpty(infoEntity.getVariableStructure())) {
            String functionName = "set_value_memory";
            String llmConfig = LargeModelFunctionEnum.valueOf(functionName).getFunction().getVariableStructureLLMConfig(infoEntity.getVariableStructure()).get(0);
            Tool tool = JsonUtils.deSerialize(llmConfig, Tool.class);
            tools.add(tool);
        }
        //开启长期记忆
        if (CommonConstant.YOrN.Y.equals(infoEntity.getIsLongMemory())) {
            String functionName = "set_long_memory";
            String llmConfig = LargeModelFunctionEnum.valueOf(functionName).getFunction().getLLMConfig().get(0);
            Tool tool = JsonUtils.deSerialize(llmConfig, Tool.class);
            tools.add(tool);
        }

        String output = agentApplicationInfoService.callAgentApplication(dialogsId, infoEntity.getLargeModel(),
                infoEntity.getUnitIds(), infoEntity.getAgentSystem(), kdIdList.toArray(new Integer[0]), infoEntity.getCommunicationTurn(),
                infoEntity.getTopP(), messages, tools, httpServletResponse);


        //保存对话记录
        // 例句回答时间戳
        Long outputTimestamp = System.currentTimeMillis();

        BizAgentApplicationDialoguesRecordEntity inputRecord = new BizAgentApplicationDialoguesRecordEntity();
        inputRecord.setAgentId(infoEntity.getAgentId());
        inputRecord.setMemberId(userBaseEntity.getUserId());
        inputRecord.setContent(input);
        inputRecord.setDialogsId(dialogsId);
        inputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.USER);
        inputRecord.setTimestamp(inputTimestamp);

        BizAgentApplicationDialoguesRecordEntity outputRecord = new BizAgentApplicationDialoguesRecordEntity();
        outputRecord.setRole(AgentApplicationDialoguesRecordConstants.ROLE.ASSISTANT);
        outputRecord.setAgentId(infoEntity.getAgentId());
        outputRecord.setDialogsId(dialogsId);
        outputRecord.setMemberId(userBaseEntity.getUserId());
        outputRecord.setContent(output);
        outputRecord.setTimestamp(outputTimestamp);

        bizAgentApplicationDialoguesRecordService.save(inputRecord);
        bizAgentApplicationDialoguesRecordService.save(outputRecord);
    }

    @Override
    public List<String> createContinueQuestions(String input) {
        BizAgentApplicationGcConfigEntity configEntity = bizAgentApplicationGcConfigService.getByConfigCode(AgentApplicationGCConfigConstants.AGENT_CONTINUE_QUESTIONS);
        if (null == configEntity) {
            throw new BusinessException("创建[开场白]配置不存在");
        }


        String configSystem = configEntity.getConfigSystem();
        configSystem = configSystem.replace("${input}", input);
        MultiContent systemMultiContent = new MultiContent();
        systemMultiContent.setText(configSystem);
        systemMultiContent.setType("text");
        List<MultiContent> multiContents = new ArrayList<>();
        multiContents.add(systemMultiContent);
        Message message = new Message();
        message.setContent(multiContents);
        message.setRole(AgentApplicationDialoguesRecordConstants.ROLE.USER);


        LargeModelResponse largeModelResponse = new LargeModelResponse();
        largeModelResponse.setModel(configEntity.getLargeModel());
        largeModelResponse.setMessages(new ArrayList<Message>() {{
            add(message);
        }}.toArray(new Message[1]));
        largeModelResponse.setTopP(configEntity.getTopP());
        largeModelResponse.setUser("POC-CONTINUE-QUESTIONS");

        LargeModelDemandResult largeModelDemandResult = llmService.chat(largeModelResponse);
        if (largeModelDemandResult == null || !"0".equals(largeModelDemandResult.getCode())) {
            logger.error("continue question error ,largeModelDemandResult:{} , largeModelResponse:{}", largeModelDemandResult != null ? largeModelDemandResult.toString() : StringUtils.EMPTY
                    , largeModelResponse);
//            throw new BusinessException("追问失败");
            return null;
        }
        String res = largeModelDemandResult.getMessage();
        int start = res.lastIndexOf("[");
        int end = res.lastIndexOf("]");
        return JsonUtils.deSerialize(res.substring(start, end + 1), new TypeReference<List<String>>() {
        }.getType());
    }

    private void buildMessages(String dialogsId, String agentId, Long userId, List<Message> messages, String input) throws Exception {
        BizAgentApplicationDialoguesRecordEntity recordEntity = new BizAgentApplicationDialoguesRecordEntity();
        recordEntity.setDialogsId(dialogsId);
        recordEntity.setMemberId(userId);
        recordEntity.setAgentId(agentId);
        List<BizAgentApplicationDialoguesRecordEntity> recordEntities = bizAgentApplicationDialoguesRecordService.findByExample(recordEntity, null);
        if (CollectionUtils.isNotEmpty(recordEntities)) {
            for (BizAgentApplicationDialoguesRecordEntity entity : recordEntities) {
                Message message = new Message();
                MultiContent multiContent = new MultiContent();
                multiContent.setType("text");
                multiContent.setText(entity.getContent());
                message.setContent(new ArrayList<MultiContent>() {{
                    add(multiContent);
                }});
                message.setRole(entity.getRole());
                messages.add(message);
            }
        }
        Message message = new Message();
        MultiContent multiContent = new MultiContent();
        multiContent.setType("text");
        multiContent.setText(input);
        message.setContent(new ArrayList<MultiContent>() {{
            add(multiContent);
        }});
        message.setRole(AgentApplicationDialoguesRecordConstants.ROLE.USER);
        messages.add(message);
        logger.info("--------- Build Messages dialogsId:{},agentId:{},messages:{}--------------", dialogsId, agentId, messages);
    }

}
