package cn.com.poc.expose.rest;

import cn.com.poc.agent_application.dto.AgentApplicationCreateContinueQuesDto;
import cn.com.poc.agent_application.dto.AgentApplicationInfoDto;
import cn.com.poc.agent_application.dto.AgentApplicationInfoSearchDto;
import cn.com.poc.agent_application.dto.BizAgentApplicationPublishDto;
import cn.com.poc.expose.dto.AgentApplicationDto;
import cn.com.poc.expose.dto.DialoguesContextDto;
import cn.com.poc.expose.dto.SearchAgentApplicationDto;
import cn.com.poc.expose.dto.UserDialoguesDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Permission(value = Access.Safety)
public interface AgentApplicationRest extends BaseRest {

    /**
     * 创建对话
     */
    String createDialogues(@RequestParam String agentId) throws Exception;

    /**
     * 调用 已发布Agent应用
     */
    void callAgentApplication(@RequestBody AgentApplicationDto dto, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 获取 已发布Agent应用列表
     */
    @Permission(value = Access.Anonymous)
    List<SearchAgentApplicationDto> agentApplicationList(@RequestBody AgentApplicationInfoSearchDto dto, PagingInfo pagingInfo) throws Exception;

    /**
     * 获取 已发布应用详情
     */
    @Permission(value = Access.Anonymous)
    BizAgentApplicationPublishDto getInfo(@RequestParam String agentId) throws Exception;

    /**
     * 下架已发布应用
     */
    void unPublish(@RequestParam String agentId) throws Exception;

    /**
     * 追问
     */
    List<String> createContinueQuestions(@RequestBody AgentApplicationCreateContinueQuesDto dto) throws Exception;

    /**
     * 获取用户已创建的对话记录
     */
    List<UserDialoguesDto> getUserDialogues() throws Exception;

    /**
     * 关闭对话
     */
    void closeDialogues(@RequestParam String dialogueId) throws Exception;

    /**
     * 关闭对话[批量]
     */
    void batchCloseDialogues(@RequestBody List<String> dialogueIds);

    /**
     * 获取对话上下文
     */
    List<DialoguesContextDto> getDialogueContext(@RequestParam String dialogueId) throws Exception;

}
